/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import xox.labvorty.ssm.SSMRebornCustomParticleTypes;

public class TheSendingParticleOptions
implements ParticleOptions {
    public final Vector3f color;
    public final double centerx;
    public final double centery;
    public final double centerz;
    public final double degreesx;
    public final double degreesy;
    public final double degreesz;
    public final double speedx;
    public final double speedy;
    public final double speedz;
    public static final Codec<TheSendingParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p -> p.color), (App)Codec.DOUBLE.fieldOf("centerx").forGetter(c1 -> c1.centerx), (App)Codec.DOUBLE.fieldOf("centery").forGetter(c2 -> c2.centery), (App)Codec.DOUBLE.fieldOf("centerz").forGetter(c3 -> c3.centerz), (App)Codec.DOUBLE.fieldOf("degreesx").forGetter(d1 -> d1.degreesx), (App)Codec.DOUBLE.fieldOf("degreesy").forGetter(d2 -> d2.degreesy), (App)Codec.DOUBLE.fieldOf("degreesz").forGetter(d3 -> d3.degreesz), (App)Codec.DOUBLE.fieldOf("speedx").forGetter(s1 -> s1.speedx), (App)Codec.DOUBLE.fieldOf("speedy").forGetter(s2 -> s2.speedy), (App)Codec.DOUBLE.fieldOf("speedz").forGetter(s3 -> s3.speedz)).apply((Applicative)instance, TheSendingParticleOptions::new));
    public static final ParticleOptions.Deserializer<TheSendingParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<TheSendingParticleOptions>(){

        public TheSendingParticleOptions fromCommand(ParticleType<TheSendingParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            Vector3f vector3f = TheSendingParticleOptions.readVector3f(reader);
            reader.expect(' ');
            double c1 = reader.readDouble();
            reader.expect(' ');
            double c2 = reader.readDouble();
            reader.expect(' ');
            double c3 = reader.readDouble();
            reader.expect(' ');
            double deg1 = reader.readDouble();
            reader.expect(' ');
            double deg2 = reader.readDouble();
            reader.expect(' ');
            double deg3 = reader.readDouble();
            reader.expect(' ');
            double spd1 = reader.readDouble();
            reader.expect(' ');
            double spd2 = reader.readDouble();
            reader.expect(' ');
            double spd3 = reader.readDouble();
            return new TheSendingParticleOptions(vector3f, c1, c2, c3, deg1, deg2, deg3, spd1, spd2, spd3);
        }

        public TheSendingParticleOptions fromNetwork(ParticleType<TheSendingParticleOptions> type, FriendlyByteBuf fbb) {
            return new TheSendingParticleOptions(TheSendingParticleOptions.readVector3f(fbb), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble(), fbb.readDouble());
        }
    };

    public TheSendingParticleOptions(Vector3f colour, double centerex, double centerey, double centerez, double degx, double degy, double degz, double spdx, double spdy, double spdz) {
        this.color = colour;
        this.centerx = centerex;
        this.centery = centerey;
        this.centerz = centerez;
        this.degreesx = degx;
        this.degreesy = degy;
        this.degreesz = degz;
        this.speedx = spdx;
        this.speedy = spdy;
        this.speedz = spdz;
    }

    public static Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
        reader.expect(' ');
        float f1 = reader.readFloat();
        reader.expect(' ');
        float f2 = reader.readFloat();
        reader.expect(' ');
        float f3 = reader.readFloat();
        return new Vector3f(f1, f2, f3);
    }

    public static Vector3f readVector3f(FriendlyByteBuf fbb) {
        return new Vector3f(fbb.readFloat(), fbb.readFloat(), fbb.readFloat());
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)SSMRebornCustomParticleTypes.THESENDING_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf fbb) {
        fbb.writeFloat(this.color.x());
        fbb.writeFloat(this.color.y());
        fbb.writeFloat(this.color.z());
        fbb.writeDouble(this.centerx);
        fbb.writeDouble(this.centery);
        fbb.writeDouble(this.centerz);
        fbb.writeDouble(this.degreesx);
        fbb.writeDouble(this.degreesy);
        fbb.writeDouble(this.degreesz);
        fbb.writeDouble(this.speedx);
        fbb.writeDouble(this.speedy);
        fbb.writeDouble(this.speedz);
    }

    public Vector3f getColor() {
        return this.color;
    }

    public double getCenterX() {
        return this.centerx;
    }

    public double getCenterY() {
        return this.centery;
    }

    public double getCenterZ() {
        return this.centerz;
    }

    public double getDegreesX() {
        return this.degreesx;
    }

    public double getDegreesY() {
        return this.degreesy;
    }

    public double getDegreesZ() {
        return this.degreesz;
    }

    public double getSpeedX() {
        return this.speedx;
    }

    public double getSpeedY() {
        return this.speedy;
    }

    public double getSpeedZ() {
        return this.speedz;
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()));
    }
}

