/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.client.gui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.init.SsmRebornModItems;
import xox.labvorty.ssm.network.PickpocketButtonMessage;
import xox.labvorty.ssm.world.inventory.PickpocketMenu;

public class PickpocketScreen
extends AbstractContainerScreen<PickpocketMenu> {
    private static final HashMap<String, Object> guistate = PickpocketMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private float handX;
    private float handY;
    private float zoneSpeed;
    private float handSpeed;
    private float cursorX;
    private float cursorY;
    private List<String> items;
    private String lightState;
    private float noticed;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private int time;
    private float previousHandX;
    private float previousHandY;
    private static int difficulty = 1;
    private float zone1X;
    private float zone1Y;
    private float zone2X;
    private float zone2Y;
    private static List<Integer> baseids = new ArrayList<Integer>();
    private static List<String> baseitems = new ArrayList<String>();
    private static List<Integer> basemin = new ArrayList<Integer>();
    private static List<Integer> basemax = new ArrayList<Integer>();
    private static List<Float> basechance = new ArrayList<Float>();
    private static List<String> baseshould = new ArrayList<String>();
    private static int currentid = 0;

    public static void setId(int id) {
        currentid = id;
    }

    public static void updateBaseData(List<Integer> ids, List<String> items, List<Integer> mins, List<Integer> maxs, List<Float> chances, List<String> should) {
        baseids = ids;
        baseitems = items;
        basemin = mins;
        basemax = maxs;
        basechance = chances;
        baseshould = should;
    }

    public PickpocketScreen(PickpocketMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.handX = (float)(this.f_96543_ / 2) - 150.0f * ((float)this.f_96543_ / 480.0f);
        this.handY = this.f_96544_ / 2;
        this.zoneSpeed = 1.0f;
        this.handSpeed = 1.0f;
        this.cursorX = 0.0f;
        this.cursorY = 0.0f;
        this.items = new ArrayList<String>();
        this.lightState = "green";
        this.noticed = 0.0f;
        this.time = 0;
        this.previousHandX = 0.0f;
        this.previousHandY = 0.0f;
        this.zone1X = 0.0f;
        this.zone1Y = 0.0f;
        this.zone2X = 0.0f;
        this.zone2Y = 0.0f;
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.f_97726_ = 0;
        this.f_97727_ = 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.cursorX = mouseX;
        this.cursorY = mouseY;
    }

    private String returnChance(float chanceVal) {
        Object returnVal = "0%";
        if (chanceVal == (float)((int)chanceVal)) {
            returnVal = (int)chanceVal + "%";
        } else if (chanceVal > 1.0f) {
            DecimalFormat df = new DecimalFormat("#.#");
            returnVal = df.format(chanceVal) + "%";
        } else if (chanceVal < 1.0f) {
            DecimalFormat df = new DecimalFormat("#.##");
            returnVal = df.format(chanceVal) + "%";
        }
        return returnVal;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        PoseStack mx = guiGraphics.m_280168_();
        float guiSize = (float)this.f_96543_ / 480.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
        mx.m_85836_();
        mx.m_85841_(guiSize / 2.0f, guiSize / 2.0f, 1.0f);
        mx.m_252880_((float)(this.f_96543_ / 2) / (guiSize / 2.0f), (float)(this.f_96544_ / 2) / (guiSize / 2.0f), 1.0f);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_main.png"), -339, -187, 0.0f, 0.0f, 678, 374, 678, 374);
        String light = "ssm_reborn:textures/screens/pickpocket_light_g.png";
        light = this.lightState.equals("green") ? "ssm_reborn:textures/screens/pickpocket_light_g.png" : (this.lightState.equals("yellow") ? "ssm_reborn:textures/screens/pickpocket_light_y.png" : (this.lightState.equals("red") ? "ssm_reborn:textures/screens/pickpocket_light_r.png" : "ssm_reborn:textures/screens/pickpocket_light_g.png"));
        guiGraphics.m_280163_(new ResourceLocation(light), -339, -187, 0.0f, 0.0f, 678, 374, 678, 374);
        mx.m_85849_();
        mx.m_85836_();
        mx.m_85841_(guiSize / 2.0f, guiSize / 2.0f, 1.0f);
        mx.m_252880_(this.zone1X / (guiSize / 2.0f), this.zone1Y / (guiSize / 2.0f), 1.0f);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_danger.png"), -70, -70, 0.0f, 0.0f, 141, 141, 141, 141);
        mx.m_85849_();
        mx.m_85836_();
        mx.m_85841_(guiSize / 2.0f, guiSize / 2.0f, 1.0f);
        mx.m_252880_(this.handX / (guiSize / 2.0f), this.handY / (guiSize / 2.0f), 1.0f);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_arm.png"), -35, -21, 0.0f, 0.0f, 70, 42, 70, 42);
        mx.m_85849_();
        mx.m_85836_();
        mx.m_85841_(guiSize / 2.0f, guiSize / 2.0f, 1.0f);
        mx.m_252880_((float)(this.f_96543_ / 2) / (guiSize / 2.0f), (float)(this.f_96544_ / 2) / (guiSize / 2.0f), 2.0f);
        float dangerbaramount = Mth.m_14036_((float)(this.noticed / 1000.0f), (float)0.0f, (float)1.0f);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_mainbar.png"), -164, 158, 0.0f, 0.0f, 300, 29, 300, 29);
        guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_dangerbar.png"), -159, 163, 0.0f, 0.0f, (int)(290.0f * dangerbaramount), 19, (int)(290.0f * dangerbaramount), 19);
        int renderPriority = 0;
        for (int i = 0; i < baseids.size(); ++i) {
            if (currentid != baseids.get(i) || !baseshould.get(i).equals("true")) continue;
            guiGraphics.m_280163_(new ResourceLocation("ssm_reborn:textures/screens/pickpocket_itemlist.png"), -330 + renderPriority * 45, -217, 0.0f, 0.0f, 40, 60, 40, 60);
            guiGraphics.m_280480_(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(baseitems.get(i)))), -318 + renderPriority * 45, -203);
            float chanceNum = basechance.get(i).floatValue() * 100.0f;
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.returnChance(chanceNum)), -310 + renderPriority * 45, -174, 0xFFFFFF);
            ++renderPriority;
        }
        mx.m_85849_();
        BakedModel bakedmodel = minecraft.m_91291_().m_174264_(new ItemStack((ItemLike)SsmRebornModItems.TEN_ST.get()), (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        boolean flag = !bakedmodel.m_7547_();
        mx.m_85836_();
        mx.m_252880_((float)(this.f_96543_ / 4 * 3), (float)(this.f_96544_ / 2), 2000.0f);
        mx.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        mx.m_85841_(32.0f * guiSize, 32.0f * guiSize, 32.0f * guiSize);
        mx.m_252781_(Axis.f_252436_.m_252977_((float)this.world.m_46468_()));
        if (flag) {
            Lighting.m_84930_();
        }
        minecraft.m_91291_().m_115143_(new ItemStack((ItemLike)SsmRebornModItems.TEN_ST.get()), ItemDisplayContext.GUI, false, mx, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        guiGraphics.m_280262_();
        if (flag) {
            Lighting.m_84931_();
        }
        mx.m_85849_();
        RandomSource randomsource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexconsumer2 = bufferSource.m_6299_(RenderType.m_110502_());
        float f5 = ((float)this.time + partialTicks) % 2000.0f / 2000.0f;
        float f7 = 0.5f;
        mx.m_85836_();
        mx.m_252880_((float)(this.f_96543_ / 4 * 3), (float)(this.f_96544_ / 2), 1000.0f);
        mx.m_85841_(guiSize, guiSize, guiSize);
        for (int i = 0; i < 20; ++i) {
            mx.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
            mx.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
            mx.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f));
            mx.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
            mx.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
            mx.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f + f5 * 90.0f));
            float f3 = randomsource.m_188501_() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = randomsource.m_188501_() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f matrix4f = mx.m_85850_().m_252922_();
            int j = 255;
            PickpocketScreen.vertex1(vertexconsumer2, matrix4f, j);
            PickpocketScreen.vertex2(vertexconsumer2, matrix4f, f3, f4);
            PickpocketScreen.vertex3(vertexconsumer2, matrix4f, f3, f4);
            PickpocketScreen.vertex1(vertexconsumer2, matrix4f, j);
            PickpocketScreen.vertex3(vertexconsumer2, matrix4f, f3, f4);
            PickpocketScreen.vertex4(vertexconsumer2, matrix4f, f3, f4);
            PickpocketScreen.vertex1(vertexconsumer2, matrix4f, j);
            PickpocketScreen.vertex4(vertexconsumer2, matrix4f, f3, f4);
            PickpocketScreen.vertex2(vertexconsumer2, matrix4f, f3, f4);
        }
        mx.m_85849_();
        RenderSystem.disableBlend();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    private static void vertex1(VertexConsumer consumer, Matrix4f matrix, int alpha) {
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(209, 172, 127, alpha).m_5752_();
    }

    private static void vertex2(VertexConsumer consumer, Matrix4f matrix, float length, float width) {
        consumer.m_252986_(matrix, -HALF_SQRT_3 * width, length, -0.5f * width).m_6122_(209, 172, 127, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer consumer, Matrix4f matrix, float length, float width) {
        consumer.m_252986_(matrix, HALF_SQRT_3 * width, length, -0.5f * width).m_6122_(209, 172, 127, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer consumer, Matrix4f matrix, float length, float width) {
        consumer.m_252986_(matrix, 0.0f, length, 1.0f * width).m_6122_(209, 172, 127, 0).m_5752_();
    }

    public boolean countHandEllipseExit(float ellipseX, float ellipseY, float radiusX, float radiusY, float rectX, float rectY, float rectSize) {
        float closestY;
        float distanceY;
        float scaledX = (rectX - ellipseX) / radiusX;
        float scaledY = (rectY - ellipseY) / radiusY;
        float scaledSizeX = rectSize / radiusX;
        float scaledSizeY = rectSize / radiusY;
        float closestX = Math.max(scaledX, Math.min(0.0f, scaledX + scaledSizeX));
        float distanceX = -closestX;
        return distanceX * distanceX + (distanceY = -(closestY = Math.max(scaledY, Math.min(0.0f, scaledY + scaledSizeY)))) * distanceY < 1.0f;
    }

    public static boolean doesHandTouchZone(double ellipseX, double ellipseY, double xRadius, double yRadius, double circleX, double circleY, double circleRadius) {
        int samples = 100;
        double angleStep = Math.PI * 2 / (double)samples;
        for (int i = 0; i < samples; ++i) {
            double y;
            double dy;
            double theta = (double)i * angleStep;
            double x = ellipseX + xRadius * Math.cos(theta);
            double dx = x - circleX;
            double distanceSquared = dx * dx + (dy = (y = ellipseY + yRadius * Math.sin(theta)) - circleY) * dy;
            if (!(distanceSquared < circleRadius * circleRadius)) continue;
            return true;
        }
        return false;
    }

    protected void m_181908_() {
        int currentTime;
        ++this.time;
        float guiSize = (float)this.f_96543_ / 480.0f;
        float sined = (float)this.time / 10.0f;
        this.zone1Y = (float)(this.f_96544_ / 2) + Mth.m_14031_((float)sined) * 28.0f * guiSize;
        if (this.countHandEllipseExit(this.handX, this.handY, 17.5f * guiSize, 10.5f * guiSize, (float)(this.f_96543_ / 4 * 3) - 8.0f * guiSize, (float)(this.f_96544_ / 2) - 8.0f * guiSize, 16.0f * guiSize)) {
            for (int i = 0; i < baseids.size(); ++i) {
                if (baseids.get(i) != currentid) continue;
                String item = baseitems.get(i);
                int min = basemin.get(i);
                int max = basemax.get(i);
                float chance = basechance.get(i).floatValue();
                SsmRebornMod.PACKET_HANDLER.sendToServer((Object)new PickpocketButtonMessage(0, this.x, this.y, this.z, item, min, max, chance));
                PickpocketButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z, item, min, max, chance);
            }
            this.f_96541_.f_91074_.m_6915_();
        }
        if (PickpocketScreen.doesHandTouchZone(this.handX, this.handY, 17.5f * guiSize, 10.5f * guiSize, this.zone1X, this.zone1Y, 35.0f * guiSize)) {
            this.noticed += 20.0f;
        }
        if ((currentTime = this.time % 300) > 0 && currentTime < 150) {
            this.lightState = "green";
        } else if (currentTime > 150 && currentTime < 200) {
            this.lightState = "yellow";
        } else if (currentTime > 200 && currentTime < 300) {
            this.lightState = "red";
        }
        if (this.lightState.equals("red") && (this.previousHandX != this.handX || this.previousHandY != this.handY)) {
            float hxd = Mth.m_14154_((float)((this.previousHandX - this.handX) / guiSize)) * 15.0f;
            float hyd = Mth.m_14154_((float)((this.previousHandY - this.handY) / guiSize)) * 15.0f;
            float danger = hxd + hyd;
            this.noticed += danger;
        }
        float addX = this.cursorX - this.handX;
        float addY = this.cursorY - this.handY;
        float distance = Mth.m_14116_((float)(addX * addX + addY * addY));
        float maxSpeed = 1.0f;
        float zeroX = (float)(this.f_96543_ / 2) - 169.5f * guiSize;
        float zeroY = (float)(this.f_96544_ / 2) - 93.5f * guiSize;
        float minX = zeroX + 21.5f * guiSize;
        float maxX = zeroX + 288.0f * guiSize;
        float minY = zeroY + 14.5f * guiSize;
        float maxY = zeroY + 168.0f * guiSize;
        this.previousHandX = this.handX;
        this.previousHandY = this.handY;
        if (distance > maxSpeed) {
            float normX = addX / distance;
            float normY = addY / distance;
            this.handX += normX * maxSpeed * guiSize;
            this.handY += normY * maxSpeed * guiSize;
        } else {
            this.handX += addX * 0.2f;
            this.handY += addY * 0.2f;
        }
        this.handX = Mth.m_14036_((float)this.handX, (float)minX, (float)maxX);
        this.handY = Mth.m_14036_((float)this.handY, (float)minY, (float)maxY);
        if (this.noticed >= 1000.0f) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_7856_() {
        super.m_7856_();
        SsmRebornMod.LOGGER.info("Screen opened with id: " + currentid);
        this.handX = (float)(this.f_96543_ / 2) - 150.0f * ((float)this.f_96543_ / 480.0f);
        this.handY = this.f_96544_ / 2;
        if (difficulty == 1) {
            this.zone1X = this.f_96543_ / 2;
            this.zone1Y = this.f_96544_ / 2;
        }
    }
}

