/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import xox.labvorty.ssm.init.SsmRebornModEntities;
import xox.labvorty.ssm.init.SsmRebornModItems;
import xox.labvorty.ssm.procedures.DaggerHitProcedure;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class DaggerEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)SsmRebornModItems.DAGGER_THROWABLE.get());

    public DaggerEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)SsmRebornModEntities.DAGGER.get(), world);
    }

    public DaggerEntity(EntityType<? extends DaggerEntity> type, Level world) {
        super(type, world);
    }

    public DaggerEntity(EntityType<? extends DaggerEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public DaggerEntity(EntityType<? extends DaggerEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        DaggerHitProcedure.execute((LevelAccessor)this.m_9236_(), entityHitResult.m_82443_());
        this.m_146870_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_ && !this.m_9236_().f_46443_) {
            this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(1.0)).forEach(player -> {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.m_7941_());
                this.m_146870_();
            });
        }
    }

    public static DaggerEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return DaggerEntity.shoot(world, entity, source, 1.0f, 0.0, 0);
    }

    public static DaggerEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return DaggerEntity.shoot(world, entity, source, pullingPower * 1.0f, 0.0, 0);
    }

    public static DaggerEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        DaggerEntity entityarrow = new DaggerEntity((EntityType<? extends DaggerEntity>)((EntityType)SsmRebornModEntities.DAGGER.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        return entityarrow;
    }

    public static DaggerEntity shoot(LivingEntity entity, LivingEntity target) {
        DaggerEntity entityarrow = new DaggerEntity((EntityType<? extends DaggerEntity>)((EntityType)SsmRebornModEntities.DAGGER.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(0.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        return entityarrow;
    }
}

