/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm.IlliaCurrencyStorage;
import xox.labvorty.ssm.JdbDataStorage;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.procedures.VCalculatorProcedure;
import xox.labvorty.ssm.world.inventory.ATMScreenVMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ATMScreenVButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final int amountOfV;

    public ATMScreenVButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.amountOfV = buffer.readInt();
    }

    public ATMScreenVButtonMessage(int buttonID, int x, int y, int z, int amountOfV) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.amountOfV = amountOfV;
    }

    public static void buffer(ATMScreenVButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.amountOfV);
    }

    public static void handler(ATMScreenVButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            int amountOfV = message.amountOfV;
            ATMScreenVButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, amountOfV);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, int amountOfV) {
        ServerLevel level;
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ATMScreenVMenu.guistate;
        MinecraftServer server = world.m_7654_();
        String name = entity.m_5446_().getString();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            IlliaCurrencyStorage data = (IlliaCurrencyStorage)serverLevel.m_8895_().m_164861_(IlliaCurrencyStorage::load, IlliaCurrencyStorage::new, "illia_currency_storage");
            JdbDataStorage data1 = (JdbDataStorage)serverLevel.m_8895_().m_164861_(JdbDataStorage::load, JdbDataStorage::new, "jdb_data_storage");
            if (data != null) {
                if (buttonID == 0) {
                    VCalculatorProcedure.givePlayerBills(amountOfV, (LevelAccessor)world, (Entity)entity);
                    data.updateDataByName(name, amountOfV, 0, "deductV");
                    data1.addData(name, "false", amountOfV, "phoneui.withdraw.key");
                }
                if (buttonID == 1) {
                    int trueamountofv = VCalculatorProcedure.calculateAmount((LevelAccessor)world, (Entity)entity);
                    data.updateDataByName(name, amountOfV, 0, "addV");
                    VCalculatorProcedure.givePlayerBills(trueamountofv -= amountOfV, (LevelAccessor)world, (Entity)entity);
                    data1.addData(name, "true", amountOfV, "phoneui.deposit.key");
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(ATMScreenVButtonMessage.class, ATMScreenVButtonMessage::buffer, ATMScreenVButtonMessage::new, ATMScreenVButtonMessage::handler);
    }
}

