/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.network.SsmRebornModVariables;
import xox.labvorty.ssm.world.inventory.LodeSkintMagicUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LodeSkintMagicUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String spell;

    public LodeSkintMagicUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.spell = buffer.m_130277_();
    }

    public LodeSkintMagicUIButtonMessage(int buttonID, int x, int y, int z, String spell) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.spell = spell;
    }

    public static void buffer(LodeSkintMagicUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.m_130070_(message.spell);
    }

    public static void handler(LodeSkintMagicUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            String spell = message.spell;
            LodeSkintMagicUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, spell);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, String spell) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = LodeSkintMagicUIMenu.guistate;
        if (buttonID == 0) {
            String _setval1 = ((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).MagicSlot2;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagicSlot3 = _setval1;
                capability.syncPlayerVariables((Entity)entity);
            });
            String _setval2 = ((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).MagicSlot1;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagicSlot2 = _setval2;
                capability.syncPlayerVariables((Entity)entity);
            });
            String _setval = spell;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagicSlot1 = _setval;
                capability.syncPlayerVariables((Entity)entity);
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(LodeSkintMagicUIButtonMessage.class, LodeSkintMagicUIButtonMessage::buffer, LodeSkintMagicUIButtonMessage::new, LodeSkintMagicUIButtonMessage::handler);
    }
}

