/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.procedures.SendPlayerToArheiProcedure;
import xox.labvorty.ssm.procedures.SendPlayerToDreamProcedure;
import xox.labvorty.ssm.world.inventory.LodeSkintTeleportationUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LodeSkintTeleportationUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public LodeSkintTeleportationUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public LodeSkintTeleportationUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(LodeSkintTeleportationUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(LodeSkintTeleportationUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            LodeSkintTeleportationUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = LodeSkintTeleportationUIMenu.guistate;
        if (buttonID == 0) {
            SendPlayerToArheiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            SendPlayerToDreamProcedure.execute((LevelAccessor)world, 0.0, 100.0, 0.0, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(LodeSkintTeleportationUIButtonMessage.class, LodeSkintTeleportationUIButtonMessage::buffer, LodeSkintTeleportationUIButtonMessage::new, LodeSkintTeleportationUIButtonMessage::handler);
    }
}

