/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.network.SsmRebornModVariables;
import xox.labvorty.ssm.world.inventory.MagicCardsMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagicCardsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MagicCardsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MagicCardsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MagicCardsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MagicCardsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MagicCardsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        String _setval;
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MagicCardsMenu.guistate;
        if (buttonID == 0) {
            _setval = ((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).MagicSlot1;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagciSlotMain = _setval;
                capability.syncPlayerVariables((Entity)entity);
            });
            SsmRebornMod.LOGGER.info("New main spell from slot1: " + _setval);
        }
        if (buttonID == 1) {
            _setval = ((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).MagicSlot2;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagciSlotMain = _setval;
                capability.syncPlayerVariables((Entity)entity);
            });
            SsmRebornMod.LOGGER.info("New main spell from slot2: " + _setval);
        }
        if (buttonID == 2) {
            _setval = ((SsmRebornModVariables.PlayerVariables)entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).MagicSlot3;
            entity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.MagciSlotMain = _setval;
                capability.syncPlayerVariables((Entity)entity);
            });
            SsmRebornMod.LOGGER.info("New main spell from slot3: " + _setval);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(MagicCardsButtonMessage.class, MagicCardsButtonMessage::buffer, MagicCardsButtonMessage::new, MagicCardsButtonMessage::handler);
    }
}

