/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.world.inventory.PhoneIlliaUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PhoneIlliaUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String typeOfHand;
    private final String typeOfApp;
    private final int appSlotNumber;
    private final String nameOfOwner;
    private final int price;

    public PhoneIlliaUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.typeOfHand = buffer.m_130136_(Short.MAX_VALUE);
        this.typeOfApp = buffer.m_130136_(Short.MAX_VALUE);
        this.appSlotNumber = buffer.readInt();
        this.nameOfOwner = buffer.m_130136_(Short.MAX_VALUE);
        this.price = buffer.readInt();
    }

    public PhoneIlliaUIButtonMessage(int buttonID, int x, int y, int z, String typeOfHand, String typeOfApp, int appSlotNumber, String nameOfOwner, int price) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.typeOfHand = typeOfHand;
        this.typeOfApp = typeOfApp;
        this.appSlotNumber = appSlotNumber;
        this.nameOfOwner = nameOfOwner;
        this.price = price;
    }

    public static void buffer(PhoneIlliaUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.m_130072_(message.typeOfHand, Short.MAX_VALUE);
        buffer.m_130072_(message.typeOfApp, Short.MAX_VALUE);
        buffer.writeInt(message.appSlotNumber);
        buffer.m_130072_(message.nameOfOwner, Short.MAX_VALUE);
        buffer.writeInt(message.price);
    }

    public static void handler(PhoneIlliaUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            String typeOfHand = message.typeOfHand;
            String typeOfApp = message.typeOfApp;
            int appSlotNumber = message.appSlotNumber;
            String nameOfOwner = message.nameOfOwner;
            int price = message.price;
            PhoneIlliaUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, typeOfHand, typeOfApp, appSlotNumber, nameOfOwner, price);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, String typeOfHand, String typeOfApp, int appSlotNumber, String nameOfOwner, int price) {
        Level world = entity.m_9236_();
        Object appNum = "";
        HashMap<String, Object> guistate = PhoneIlliaUIMenu.guistate;
        if (buttonID == 0) {
            if (typeOfHand.equals("right")) {
                appNum = "app" + appSlotNumber;
                entity.m_21205_().m_41784_().m_128359_((String)appNum, typeOfApp);
            } else if (typeOfHand.equals("left")) {
                appNum = "app" + appSlotNumber;
                entity.m_21206_().m_41784_().m_128359_((String)appNum, typeOfApp);
            }
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(PhoneIlliaUIButtonMessage.class, PhoneIlliaUIButtonMessage::buffer, PhoneIlliaUIButtonMessage::new, PhoneIlliaUIButtonMessage::handler);
    }
}

