/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xox.labvorty.ssm.SsmRebornMod;
import xox.labvorty.ssm.world.inventory.PickpocketMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PickpocketButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private final String item;
    private final int min;
    private final int max;
    private final float chance;

    public PickpocketButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.item = buffer.m_130277_();
        this.min = buffer.readInt();
        this.max = buffer.readInt();
        this.chance = buffer.readFloat();
    }

    public PickpocketButtonMessage(int buttonID, int x, int y, int z, String item, int min, int max, float chance) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.item = item;
        this.min = min;
        this.max = max;
        this.chance = chance;
    }

    public static void buffer(PickpocketButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.m_130070_(message.item);
        buffer.writeInt(message.min);
        buffer.writeInt(message.max);
        buffer.writeFloat(message.chance);
    }

    public static void handler(PickpocketButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            String item = message.item;
            int min = message.min;
            int max = message.max;
            float chance = message.chance;
            PickpocketButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, item, min, max, chance);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, String item, int min, int max, float chance) {
        RandomSource random;
        float lottery;
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PickpocketMenu.guistate;
        if (buttonID == 0 && (lottery = (random = RandomSource.m_216327_()).m_188501_()) <= chance) {
            ResourceLocation loc = new ResourceLocation(item);
            Item itemion = (Item)ForgeRegistries.ITEMS.getValue(loc);
            ItemStack stack = new ItemStack((ItemLike)itemion);
            int trueamount = Mth.m_216287_((RandomSource)random, (int)min, (int)max);
            stack.m_41764_(trueamount);
            ItemHandlerHelper.giveItemToPlayer((Player)entity, (ItemStack)stack);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(PickpocketButtonMessage.class, PickpocketButtonMessage::buffer, PickpocketButtonMessage::new, PickpocketButtonMessage::handler);
    }
}

