/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import xox.labvorty.ssm.SsmRebornMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SsmRebornModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SsmRebornMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        SsmRebornMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.canPrunus = message.data.canPrunus;
                    variables.dangerLevel = message.data.dangerLevel;
                    variables.isInSafeZone = message.data.isInSafeZone;
                    variables.IsPRInterfaceEnabled = message.data.IsPRInterfaceEnabled;
                    variables.MagciSlotMain = message.data.MagciSlotMain;
                    variables.MagicSlot1 = message.data.MagicSlot1;
                    variables.MagicSlot2 = message.data.MagicSlot2;
                    variables.MagicSlot3 = message.data.MagicSlot3;
                    variables.PlayerMana = message.data.PlayerMana;
                    variables.PlayerSparkPower = message.data.PlayerSparkPower;
                    variables.PrunusDim = message.data.PrunusDim;
                    variables.PrunusX = message.data.PrunusX;
                    variables.PrunusY = message.data.PrunusY;
                    variables.PrunusZ = message.data.PrunusZ;
                    variables.SparkCharge = message.data.SparkCharge;
                    variables.SparkCharging = message.data.SparkCharging;
                    variables.StopLoginMessage = message.data.StopLoginMessage;
                    variables.IsTeleporting = message.data.IsTeleporting;
                    variables.StatusElectrified = message.data.StatusElectrified;
                    variables.StatusBreathless = message.data.StatusBreathless;
                    variables.StatusFreezing = message.data.StatusFreezing;
                    variables.StatusInfected = message.data.StatusInfected;
                    variables.StatusPoisoned = message.data.StatusPoisoned;
                    variables.StatusPowerless = message.data.StatusPowerless;
                    variables.StatusOnfire = message.data.StatusOnfire;
                    variables.SparkTechniquesActive = message.data.SparkTechniquesActive;
                    variables.TimeUnlinked = message.data.TimeUnlinked;
                    variables.TimeUnlinkedPeriod = message.data.TimeUnlinkedPeriod;
                    variables.TimePressure = message.data.TimePressure;
                    variables.InterworlderMask = message.data.InterworlderMask;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean canPrunus = false;
        public double dangerLevel = 0.0;
        public boolean isInSafeZone = false;
        public boolean IsPRInterfaceEnabled = false;
        public String MagciSlotMain = "";
        public String MagicSlot1 = "";
        public String MagicSlot2 = "";
        public String MagicSlot3 = "";
        public double PlayerMana = 0.0;
        public double PlayerSparkPower = 1000000.0;
        public String PrunusDim = "\"\"";
        public double PrunusX = 0.0;
        public double PrunusY = 0.0;
        public double PrunusZ = 0.0;
        public double SparkCharge = 0.0;
        public boolean SparkCharging = false;
        public boolean StopLoginMessage = false;
        public boolean IsTeleporting = false;
        public double StatusElectrified = 0.0;
        public double StatusBreathless = 0.0;
        public double StatusFreezing = 0.0;
        public double StatusInfected = 0.0;
        public double StatusPoisoned = 0.0;
        public double StatusPowerless = 0.0;
        public double StatusOnfire = 0.0;
        public boolean SparkTechniquesActive = false;
        public boolean TimeUnlinked = false;
        public double TimeUnlinkedPeriod = 0.0;
        public double TimePressure = 0.0;
        public ItemStack InterworlderMask = ItemStack.f_41583_;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("canPrunus", this.canPrunus);
            nbt.m_128347_("dangerLevel", this.dangerLevel);
            nbt.m_128379_("isInSafeZone", this.isInSafeZone);
            nbt.m_128379_("IsPRInterfaceEnabled", this.IsPRInterfaceEnabled);
            nbt.m_128359_("MagciSlotMain", this.MagciSlotMain);
            nbt.m_128359_("MagicSlot1", this.MagicSlot1);
            nbt.m_128359_("MagicSlot2", this.MagicSlot2);
            nbt.m_128359_("MagicSlot3", this.MagicSlot3);
            nbt.m_128347_("PlayerMana", this.PlayerMana);
            nbt.m_128347_("PlayerSparkPower", this.PlayerSparkPower);
            nbt.m_128359_("PrunusDim", this.PrunusDim);
            nbt.m_128347_("PrunusX", this.PrunusX);
            nbt.m_128347_("PrunusY", this.PrunusY);
            nbt.m_128347_("PrunusZ", this.PrunusZ);
            nbt.m_128347_("SparkCharge", this.SparkCharge);
            nbt.m_128379_("SparkCharging", this.SparkCharging);
            nbt.m_128379_("StopLoginMessage", this.StopLoginMessage);
            nbt.m_128379_("IsTeleporting", this.IsTeleporting);
            nbt.m_128347_("StatusElectrified", this.StatusElectrified);
            nbt.m_128347_("StatusBreathless", this.StatusBreathless);
            nbt.m_128347_("StatusFreezing", this.StatusFreezing);
            nbt.m_128347_("StatusInfected", this.StatusInfected);
            nbt.m_128347_("StatusPoisoned", this.StatusPoisoned);
            nbt.m_128347_("StatusPowerless", this.StatusPowerless);
            nbt.m_128347_("StatusOnfire", this.StatusOnfire);
            nbt.m_128379_("SparkTechniquesActive", this.SparkTechniquesActive);
            nbt.m_128379_("TimeUnlinked", this.TimeUnlinked);
            nbt.m_128347_("TimeUnlinkedPeriod", this.TimeUnlinkedPeriod);
            nbt.m_128347_("TimePressure", this.TimePressure);
            nbt.m_128365_("InterworlderMask", (Tag)this.InterworlderMask.m_41739_(new CompoundTag()));
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.canPrunus = nbt.m_128471_("canPrunus");
            this.dangerLevel = nbt.m_128459_("dangerLevel");
            this.isInSafeZone = nbt.m_128471_("isInSafeZone");
            this.IsPRInterfaceEnabled = nbt.m_128471_("IsPRInterfaceEnabled");
            this.MagciSlotMain = nbt.m_128461_("MagciSlotMain");
            this.MagicSlot1 = nbt.m_128461_("MagicSlot1");
            this.MagicSlot2 = nbt.m_128461_("MagicSlot2");
            this.MagicSlot3 = nbt.m_128461_("MagicSlot3");
            this.PlayerMana = nbt.m_128459_("PlayerMana");
            this.PlayerSparkPower = nbt.m_128459_("PlayerSparkPower");
            this.PrunusDim = nbt.m_128461_("PrunusDim");
            this.PrunusX = nbt.m_128459_("PrunusX");
            this.PrunusY = nbt.m_128459_("PrunusY");
            this.PrunusZ = nbt.m_128459_("PrunusZ");
            this.SparkCharge = nbt.m_128459_("SparkCharge");
            this.SparkCharging = nbt.m_128471_("SparkCharging");
            this.StopLoginMessage = nbt.m_128471_("StopLoginMessage");
            this.IsTeleporting = nbt.m_128471_("IsTeleporting");
            this.StatusElectrified = nbt.m_128459_("StatusElectrified");
            this.StatusBreathless = nbt.m_128459_("StatusBreathless");
            this.StatusFreezing = nbt.m_128459_("StatusFreezing");
            this.StatusInfected = nbt.m_128459_("StatusInfected");
            this.StatusPoisoned = nbt.m_128459_("StatusPoisoned");
            this.StatusPowerless = nbt.m_128459_("StatusPowerless");
            this.StatusOnfire = nbt.m_128459_("StatusOnfire");
            this.SparkTechniquesActive = nbt.m_128471_("SparkTechniquesActive");
            this.TimeUnlinked = nbt.m_128471_("TimeUnlinked");
            this.TimeUnlinkedPeriod = nbt.m_128459_("TimeUnlinkedPeriod");
            this.TimePressure = nbt.m_128459_("TimePressure");
            this.InterworlderMask = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InterworlderMask"));
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ssm_reborn", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "ssm_reborn_mapvars";
        public boolean ArheiCovered = true;
        public double coldGlobalX = 0.0;
        public double coldGlobalY = 256.0;
        public double coldGlobalZ = 0.0;
        public boolean coldSpawnLocationsFixated = false;
        public double dangerLevelArhei = 1.0;
        public double dangerLevelGlobal = 0.0;
        public double misrGlobalX = 0.0;
        public double misrGlobalY = 256.0;
        public double misrGlobalZ = 0.0;
        public boolean PrunusInit = false;
        public double SparkPower = 1000000.0;
        public boolean worldSpawnLocationsFixated = false;
        public double mortisGlobalX = 0.0;
        public double mortisGlobalY = 256.0;
        public double mortisGlobalZ = 0.0;
        public boolean mortisSparkLocationInit = false;
        public boolean OnlyCertainWorldInDangerTime = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.ArheiCovered = nbt.m_128471_("ArheiCovered");
            this.coldGlobalX = nbt.m_128459_("coldGlobalX");
            this.coldGlobalY = nbt.m_128459_("coldGlobalY");
            this.coldGlobalZ = nbt.m_128459_("coldGlobalZ");
            this.coldSpawnLocationsFixated = nbt.m_128471_("coldSpawnLocationsFixated");
            this.dangerLevelArhei = nbt.m_128459_("dangerLevelArhei");
            this.dangerLevelGlobal = nbt.m_128459_("dangerLevelGlobal");
            this.misrGlobalX = nbt.m_128459_("misrGlobalX");
            this.misrGlobalY = nbt.m_128459_("misrGlobalY");
            this.misrGlobalZ = nbt.m_128459_("misrGlobalZ");
            this.PrunusInit = nbt.m_128471_("PrunusInit");
            this.SparkPower = nbt.m_128459_("SparkPower");
            this.worldSpawnLocationsFixated = nbt.m_128471_("worldSpawnLocationsFixated");
            this.mortisGlobalX = nbt.m_128459_("mortisGlobalX");
            this.mortisGlobalY = nbt.m_128459_("mortisGlobalY");
            this.mortisGlobalZ = nbt.m_128459_("mortisGlobalZ");
            this.mortisSparkLocationInit = nbt.m_128471_("mortisSparkLocationInit");
            this.OnlyCertainWorldInDangerTime = nbt.m_128471_("OnlyCertainWorldInDangerTime");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("ArheiCovered", this.ArheiCovered);
            nbt.m_128347_("coldGlobalX", this.coldGlobalX);
            nbt.m_128347_("coldGlobalY", this.coldGlobalY);
            nbt.m_128347_("coldGlobalZ", this.coldGlobalZ);
            nbt.m_128379_("coldSpawnLocationsFixated", this.coldSpawnLocationsFixated);
            nbt.m_128347_("dangerLevelArhei", this.dangerLevelArhei);
            nbt.m_128347_("dangerLevelGlobal", this.dangerLevelGlobal);
            nbt.m_128347_("misrGlobalX", this.misrGlobalX);
            nbt.m_128347_("misrGlobalY", this.misrGlobalY);
            nbt.m_128347_("misrGlobalZ", this.misrGlobalZ);
            nbt.m_128379_("PrunusInit", this.PrunusInit);
            nbt.m_128347_("SparkPower", this.SparkPower);
            nbt.m_128379_("worldSpawnLocationsFixated", this.worldSpawnLocationsFixated);
            nbt.m_128347_("mortisGlobalX", this.mortisGlobalX);
            nbt.m_128347_("mortisGlobalY", this.mortisGlobalY);
            nbt.m_128347_("mortisGlobalZ", this.mortisGlobalZ);
            nbt.m_128379_("mortisSparkLocationInit", this.mortisSparkLocationInit);
            nbt.m_128379_("OnlyCertainWorldInDangerTime", this.OnlyCertainWorldInDangerTime);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "ssm_reborn_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.canPrunus = original.canPrunus;
            clone.dangerLevel = original.dangerLevel;
            clone.IsPRInterfaceEnabled = original.IsPRInterfaceEnabled;
            clone.MagciSlotMain = original.MagciSlotMain;
            clone.MagicSlot1 = original.MagicSlot1;
            clone.MagicSlot2 = original.MagicSlot2;
            clone.MagicSlot3 = original.MagicSlot3;
            clone.PlayerMana = original.PlayerMana;
            clone.PrunusDim = original.PrunusDim;
            clone.PrunusX = original.PrunusX;
            clone.PrunusY = original.PrunusY;
            clone.PrunusZ = original.PrunusZ;
            clone.SparkCharge = original.SparkCharge;
            clone.SparkCharging = original.SparkCharging;
            clone.StopLoginMessage = original.StopLoginMessage;
            clone.SparkTechniquesActive = original.SparkTechniquesActive;
            clone.TimeUnlinked = original.TimeUnlinked;
            clone.TimeUnlinkedPeriod = original.TimeUnlinkedPeriod;
            clone.TimePressure = original.TimePressure;
            clone.InterworlderMask = original.InterworlderMask;
            if (!event.isWasDeath()) {
                clone.isInSafeZone = original.isInSafeZone;
                clone.PlayerSparkPower = original.PlayerSparkPower;
                clone.IsTeleporting = original.IsTeleporting;
                clone.StatusElectrified = original.StatusElectrified;
                clone.StatusBreathless = original.StatusBreathless;
                clone.StatusFreezing = original.StatusFreezing;
                clone.StatusInfected = original.StatusInfected;
                clone.StatusPoisoned = original.StatusPoisoned;
                clone.StatusPowerless = original.StatusPowerless;
                clone.StatusOnfire = original.StatusOnfire;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                SsmRebornMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

