/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.ssm.procedures;

import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xox.labvorty.ssm.init.SsmRebornModMobEffects;
import xox.labvorty.ssm.network.SsmRebornModVariables;

@Mod.EventBusSubscriber
public class FadingSparkTeleportPreventionProcedure {
    public static final Set<String> ALLOWED_DIMENSION = Set.of("minecraft:overworld", "ssm_reborn:dream", "ssm_reborn:time_wasteland", "ssm_reborn:prunus", "ssm_reborn:synclyte_pocket_dimension", "ssm_reborn:synclyte", "ssm_reborn:mindscape");

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        if (event == null) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean hasFadingSpark = livingEntity.m_21023_((MobEffect)SsmRebornModMobEffects.FADING_SPARK.get());
            boolean canPrunus = ((SsmRebornModVariables.PlayerVariables)livingEntity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).canPrunus;
            boolean isTimeUnlinked = ((SsmRebornModVariables.PlayerVariables)livingEntity.getCapability(SsmRebornModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SsmRebornModVariables.PlayerVariables())).TimeUnlinked;
            String dimensionID = event.getDimension().m_135782_().toString();
            boolean isAllowed = ALLOWED_DIMENSION.stream().anyMatch(d -> dimensionID.startsWith((String)d));
            if (!hasFadingSpark || canPrunus || isTimeUnlinked) {
                return;
            }
            if (!isAllowed) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                } else if (event.hasResult()) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

