/*
 * Decompiled with CFR 0.152.
 */
package net.boostedbrightness;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BoostedBrightness
implements ClientModInitializer {
    public static final int MAX_BRIGHTNESSES = 5;
    private static final Gson GSON = new Gson();
    public static double minBrightness = -1.0;
    public static double maxBrightness = 15.0;
    public static double brightnessSliderInterval = 0.05;
    private static double step = 0.1;
    public static ArrayList<Double> brightnesses;
    private static int brightnessIndex;
    private static int lastBrightnessIndex;
    private static final class_304.class_11900 BOOSTED_CATEGORY;
    private static final class_304 NEXT_BIND;
    private static final class_304 RAISE_BIND;
    private static final class_304 LOWER_BIND;
    private static final class_304[] SELECT_BINDS;
    public static class_310 client;
    public static boolean isSodiumLoaded;
    public static final Logger LOGGER;

    public static void changeBrightness(double brightness) {
        if (brightnesses == null || brightnesses.isEmpty()) {
            return;
        }
        double clampedBrightness = Math.min(maxBrightness, Math.max(minBrightness, brightness));
        brightnesses.set(BoostedBrightness.getBrightnessIndex(), clampedBrightness);
        if (client != null && BoostedBrightness.client.field_1690 != null) {
            try {
                BoostedBrightness.client.field_1690.method_42473().method_41748((Object)clampedBrightness);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set gamma value: " + e.getMessage());
            }
        }
    }

    public static int numBrightnesses() {
        return brightnesses != null ? brightnesses.size() : 0;
    }

    public static int getBrightnessIndex() {
        return brightnessIndex;
    }

    public static void setBrightnessIndex(int index) {
        if (brightnesses == null || brightnesses.isEmpty()) {
            return;
        }
        brightnessIndex = Math.max(0, Math.min(BoostedBrightness.numBrightnesses() - 1, index));
        if (client != null && BoostedBrightness.client.field_1690 != null) {
            try {
                double brightness = BoostedBrightness.getBrightness();
                BoostedBrightness.client.field_1690.method_42473().method_41748((Object)brightness);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to set gamma value: " + e.getMessage());
            }
        }
    }

    public static double getBrightness() {
        if (brightnesses == null || brightnesses.isEmpty()) {
            return 1.0;
        }
        return brightnesses.get(brightnessIndex);
    }

    public static double getBrightness(int index) {
        if (brightnesses == null || brightnesses.isEmpty() || index < 0 || index >= brightnesses.size()) {
            return 1.0;
        }
        return brightnesses.get(index);
    }

    public static void saveConfig() {
        try {
            JsonObject config = new JsonObject();
            config.addProperty("min", (Number)minBrightness);
            config.addProperty("max", (Number)maxBrightness);
            config.addProperty("step", (Number)step);
            config.addProperty("selected", (Number)(brightnessIndex + 1));
            config.addProperty("last", (Number)(lastBrightnessIndex + 1));
            if (brightnesses != null) {
                for (int i = 0; i < brightnesses.size() && i < 5; ++i) {
                    config.addProperty(String.valueOf(i + 1), (Number)brightnesses.get(i));
                }
            }
            Path configPath = BoostedBrightness.getConfigPath();
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.write(configPath, GSON.toJson((JsonElement)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            BoostedBrightness.logException(ex, "Failed to save BoostedBrightness config");
        }
        catch (Exception ex) {
            BoostedBrightness.logException(ex, "Unexpected error while saving config");
        }
    }

    public static void changeBrightness(int index, double brightness) {
        if (brightnesses == null || index < 0 || index >= brightnesses.size()) {
            return;
        }
        if (index == brightnessIndex) {
            BoostedBrightness.changeBrightness(brightness);
        } else {
            double clampedBrightness = Math.min(maxBrightness, Math.max(minBrightness, brightness));
            brightnesses.set(index, clampedBrightness);
        }
    }

    public static void logException(Exception ex, String message) {
        System.err.printf("[BoostedBrightness] %s (%s: %s)\n", message, ex.getClass().getSimpleName(), ex.getLocalizedMessage());
    }

    public void onInitializeClient() {
        isSodiumLoaded = FabricLoader.getInstance().isModLoaded("sodium");
        KeyBindingHelper.registerKeyBinding((class_304)NEXT_BIND);
        KeyBindingHelper.registerKeyBinding((class_304)RAISE_BIND);
        KeyBindingHelper.registerKeyBinding((class_304)LOWER_BIND);
        for (int i = 0; i < 5; ++i) {
            BoostedBrightness.SELECT_BINDS[i] = new class_304("key.boosted-brightness.select" + (i + 1), class_3675.class_307.field_1668, -1, BOOSTED_CATEGORY);
            KeyBindingHelper.registerKeyBinding((class_304)SELECT_BINDS[i]);
        }
        ClientTickEvents.END_CLIENT_TICK.register(this::onEndTick);
        this.loadConfig();
        client = class_310.method_1551();
        LOGGER.info("Boosted Brightness initialized" + (isSodiumLoaded ? " with Sodium compatibility" : ""));
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("boostedbrightness.json");
    }

    private void asDouble(JsonElement element, DoubleConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsDouble());
        }
    }

    private void asInt(JsonElement element, IntConsumer onSuccess) {
        if (element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
            onSuccess.accept(element.getAsInt());
        }
    }

    private void loadConfig() {
        Path configPath = BoostedBrightness.getConfigPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            brightnesses = new ArrayList();
            brightnesses.add(1.0);
            brightnesses.add(maxBrightness);
            brightnessIndex = 0;
            lastBrightnessIndex = 0;
            BoostedBrightness.saveConfig();
            return;
        }
        try {
            String configContent = new String(Files.readAllBytes(configPath));
            JsonObject config = (JsonObject)GSON.fromJson(configContent, JsonObject.class);
            if (config == null) {
                throw new JsonSyntaxException("Config file is empty or invalid");
            }
            this.asDouble(config.get("min"), min -> {
                minBrightness = min;
            });
            this.asDouble(config.get("max"), max -> {
                maxBrightness = max;
            });
            this.asDouble(config.get("step"), step -> {
                BoostedBrightness.step = step;
            });
            brightnesses = new ArrayList();
            for (int i = 1; i <= 5 && config.has(String.valueOf(i)); ++i) {
                this.asDouble(config.get(String.valueOf(i)), brightness -> brightnesses.add(brightness));
            }
            this.asInt(config.get("selected"), selected -> {
                brightnessIndex = selected - 1;
            });
            brightnessIndex = Math.max(0, Math.min(BoostedBrightness.numBrightnesses() - 1, brightnessIndex));
            if (config.has("last")) {
                this.asInt(config.get("last"), last -> {
                    lastBrightnessIndex = last - 1;
                });
                lastBrightnessIndex = Math.max(0, Math.min(BoostedBrightness.numBrightnesses() - 1, lastBrightnessIndex));
            } else {
                lastBrightnessIndex = 0;
            }
        }
        catch (JsonSyntaxException | IOException ex) {
            BoostedBrightness.logException((Exception)ex, "Failed to load BoostedBrightness config");
            brightnesses = new ArrayList();
            brightnesses.add(1.0);
            brightnesses.add(maxBrightness);
            brightnessIndex = 0;
            lastBrightnessIndex = 0;
        }
        if (brightnesses == null || brightnesses.size() < 2) {
            brightnesses = new ArrayList();
            brightnesses.add(1.0);
            brightnesses.add(maxBrightness);
            if (brightnessIndex >= brightnesses.size()) {
                brightnessIndex = 0;
            }
            if (lastBrightnessIndex >= brightnesses.size()) {
                lastBrightnessIndex = 0;
            }
        }
    }

    private void showOverlay(class_310 client) {
        if (client.field_1705 == null) {
            return;
        }
        double currentBrightness = BoostedBrightness.getBrightness();
        int percentage = isSodiumLoaded ? (int)Math.round(currentBrightness / maxBrightness * 1500.0) : (int)Math.round(currentBrightness * 100.0);
        client.field_1705.method_1758((class_2561)class_2561.method_43469((String)"overlay.boosted-brightness.change", (Object[])new Object[]{BoostedBrightness.getBrightnessIndex() + 1, percentage}).method_27694(s -> s.method_10977(class_124.field_1060)), false);
    }

    private void onEndTick(class_310 client) {
        if (brightnesses == null || brightnesses.isEmpty()) {
            return;
        }
        while (NEXT_BIND.method_1436()) {
            lastBrightnessIndex = BoostedBrightness.getBrightnessIndex();
            BoostedBrightness.setBrightnessIndex((lastBrightnessIndex + 1) % BoostedBrightness.numBrightnesses());
            this.showOverlay(client);
        }
        for (int i = 0; i < BoostedBrightness.numBrightnesses(); ++i) {
            while (SELECT_BINDS[i].method_1436()) {
                int nextBrightnessIndex = i != brightnessIndex ? i : lastBrightnessIndex;
                lastBrightnessIndex = BoostedBrightness.getBrightnessIndex();
                BoostedBrightness.setBrightnessIndex(nextBrightnessIndex);
                this.showOverlay(client);
            }
        }
        double offset = 0.0;
        while (RAISE_BIND.method_1436()) {
            offset += step;
        }
        while (LOWER_BIND.method_1436()) {
            offset -= step;
        }
        if (offset != 0.0) {
            double currentBrightness = BoostedBrightness.getBrightness();
            double newBrightness = Math.max(minBrightness, Math.min(maxBrightness, currentBrightness + offset));
            BoostedBrightness.changeBrightness(newBrightness);
            this.showOverlay(client);
        }
    }

    static {
        brightnessIndex = 0;
        lastBrightnessIndex = 0;
        BOOSTED_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)(((ModContainer)FabricLoader.getInstance().getModContainer("boostedbrightness").get()).getMetadata().getId() + ".main")));
        NEXT_BIND = new class_304("key.boosted-brightness.next", class_3675.class_307.field_1668, 66, BOOSTED_CATEGORY);
        RAISE_BIND = new class_304("key.boosted-brightness.raise", class_3675.class_307.field_1668, 93, BOOSTED_CATEGORY);
        LOWER_BIND = new class_304("key.boosted-brightness.lower", class_3675.class_307.field_1668, 91, BOOSTED_CATEGORY);
        SELECT_BINDS = new class_304[5];
        isSodiumLoaded = false;
        LOGGER = LogManager.getLogger((String)"BoostedBrightness");
    }
}

