/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.motDAnnouncer.listeners;

import de.scholle.motDAnnouncer.MotDAnnouncer;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class JoinListener
implements Listener {
    private final MotDAnnouncer plugin;

    public JoinListener(MotDAnnouncer plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        FileConfiguration motdConfig = this.plugin.getMotdConfig();
        FileConfiguration config = this.plugin.getConfig();
        String uuid = player.getUniqueId().toString();
        boolean isReturning = motdConfig.contains("players." + uuid);
        if (isReturning) {
            if (config.getBoolean("messages.returning.enabled", true)) {
                String msg = config.getString("messages.returning.text", "Welcome back %player%!");
                msg = this.applyPlaceholders(player, msg);
                player.sendMessage(msg);
            }
        } else {
            motdConfig.set("players." + uuid + ".name", (Object)player.getName());
            this.plugin.saveMotdFile();
            if (config.getBoolean("messages.first.enabled", true)) {
                String msg = config.getString("messages.first.text", "Welcome to %server_name% %player%!");
                msg = this.applyPlaceholders(player, msg);
                player.sendMessage(msg);
            }
        }
    }

    private String applyPlaceholders(Player player, String text) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        text = text.replace("%player%", player.getName()).replace("%server_name%", Bukkit.getServer().getName());
        return text;
    }
}

