/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.motDAnnouncer;

import de.scholle.motDAnnouncer.listeners.JoinListener;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MotDAnnouncer
extends JavaPlugin {
    private File motdFile;
    private FileConfiguration motdConfig;
    private static MotDAnnouncer instance;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.createMotdFile();
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getLogger().info("MotDAnnouncer has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("MotDAnnouncer has been disabled!");
    }

    private void createMotdFile() {
        this.motdFile = new File(this.getDataFolder(), "motd.yml");
        if (!this.motdFile.exists()) {
            this.motdFile.getParentFile().mkdirs();
            this.saveResource("motd.yml", false);
        }
        this.motdConfig = YamlConfiguration.loadConfiguration((File)this.motdFile);
    }

    public void saveMotdFile() {
        try {
            this.motdConfig.save(this.motdFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getMotdConfig() {
        return this.motdConfig;
    }

    public static MotDAnnouncer getInstance() {
        return instance;
    }
}

