/*
 * Decompiled with CFR 0.152.
 */
package com.codex.memory;

import com.codex.memory.MemoryClientScreenshotTimer;
import com.codex.memory.MemoryModData;
import com.codex.memory.config.MemoryClientConfig;
import java.io.File;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;

@Environment(value=EnvType.CLIENT)
public final class MemoryClientInitializer
implements ClientModInitializer {
    private static MemoryClientInitializer instance;
    private MemoryClientConfig config;
    private MemoryClientScreenshotTimer timer;

    public void onInitializeClient() {
        instance = this;
        this.applyConfig(MemoryClientConfig.loadOrCreate());
        ClientTickEvents.END_CLIENT_TICK.register(this::handleTick);
    }

    private void applyConfig(MemoryClientConfig newConfig) {
        this.config = newConfig;
        long intervalMillis = Math.max(1L, (long)newConfig.intervalSeconds()) * 1000L;
        this.timer = new MemoryClientScreenshotTimer(intervalMillis);
        MemoryModData.LOGGER.info("Memory configuration applied: automatic screenshots every {} seconds. Chat message {}.", (Object)newConfig.intervalSeconds(), (Object)(newConfig.showScreenshotMessage() ? "visible" : "hidden"));
    }

    private void handleTick(class_310 client) {
        if (client == null || this.timer == null) {
            return;
        }
        if (client.field_1687 == null || client.field_1724 == null || client.method_1493()) {
            this.timer.reset(System.currentTimeMillis());
            return;
        }
        long nowMillis = System.currentTimeMillis();
        if (!this.timer.shouldCapture(nowMillis)) {
            return;
        }
        this.captureScreenshot(client, nowMillis);
    }

    private void captureScreenshot(class_310 client, long nowMillis) {
        MemoryModData.LOGGER.debug("Capturing Memory screenshot at {}", (Object)nowMillis);
        class_318.method_1659((File)client.field_1697, (class_276)client.method_1522(), text -> {
            if (this.config.showScreenshotMessage()) {
                client.execute(() -> client.field_1705.method_1743().method_1812(text));
            }
        });
        this.timer.markCaptured(nowMillis);
    }

    public static void reloadClientConfig(MemoryClientConfig newConfig) {
        if (instance != null) {
            instance.applyConfig(newConfig);
        }
    }
}

