/*
 * Decompiled with CFR 0.152.
 */
package com.codex.memory;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class MemoryClientScreenshotTimer {
    private final long intervalMillis;
    private long lastCaptureMillis;

    public MemoryClientScreenshotTimer(long intervalMillis) {
        this.intervalMillis = intervalMillis;
        this.lastCaptureMillis = System.currentTimeMillis();
    }

    public boolean shouldCapture(long nowMillis) {
        return nowMillis - this.lastCaptureMillis >= this.intervalMillis;
    }

    public void markCaptured(long nowMillis) {
        this.lastCaptureMillis = nowMillis;
    }

    public void reset(long nowMillis) {
        this.lastCaptureMillis = nowMillis;
    }
}

