/*
 * Decompiled with CFR 0.152.
 */
package com.codex.memory.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"memory-config");
    private static final String FILE_NAME = "memory.toml";
    private static final int MIN_INTERVAL_SECONDS = 1;
    private final int intervalSeconds;
    private final boolean showScreenshotMessage;

    private MemoryClientConfig(int intervalSeconds, boolean showScreenshotMessage) {
        this.intervalSeconds = intervalSeconds;
        this.showScreenshotMessage = showScreenshotMessage;
    }

    public int intervalSeconds() {
        return this.intervalSeconds;
    }

    public boolean showScreenshotMessage() {
        return this.showScreenshotMessage;
    }

    public static MemoryClientConfig loadOrCreate() {
        MemoryClientConfig memoryClientConfig;
        block9: {
            MemoryClientConfig defaults = MemoryClientConfig.normalized(300, false);
            Path path = MemoryClientConfig.configPath();
            if (!Files.exists(path, new LinkOption[0])) {
                MemoryClientConfig.writeConfig(path, defaults);
                return defaults;
            }
            CommentedFileConfig file = MemoryClientConfig.openFile(path);
            try {
                file.load();
                MemoryClientConfig loaded = MemoryClientConfig.fromToml((CommentedConfig)file, defaults);
                MemoryClientConfig.writeToFile(file, loaded);
                memoryClientConfig = loaded;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to load {}: {}", new Object[]{FILE_NAME, t.toString(), t});
                    MemoryClientConfig.writeConfig(path, defaults);
                    return defaults;
                }
            }
            file.close();
        }
        return memoryClientConfig;
    }

    public static MemoryClientConfig overwrite(int intervalSeconds, boolean showScreenshotMessage) {
        MemoryClientConfig updated = MemoryClientConfig.normalized(intervalSeconds, showScreenshotMessage);
        MemoryClientConfig.writeConfig(MemoryClientConfig.configPath(), updated);
        return updated;
    }

    private static MemoryClientConfig fromToml(CommentedConfig config, MemoryClientConfig defaults) {
        int interval = defaults.intervalSeconds;
        Object rawInterval = config.get("interval_seconds");
        if (rawInterval instanceof Number) {
            Number number = (Number)rawInterval;
            interval = number.intValue();
        }
        boolean showMessage = defaults.showScreenshotMessage;
        Object rawShow = config.get("show_screenshot_message");
        if (rawShow instanceof Boolean) {
            Boolean bool = (Boolean)rawShow;
            showMessage = bool;
        }
        return MemoryClientConfig.normalized(interval, showMessage);
    }

    private static void writeConfig(Path path, MemoryClientConfig config) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config directory for {}", (Object)FILE_NAME, (Object)e);
            return;
        }
        try (CommentedFileConfig file = MemoryClientConfig.openFile(path);){
            file.load();
            MemoryClientConfig.writeToFile(file, config);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to write {}: {}", new Object[]{FILE_NAME, t.toString(), t});
        }
    }

    private static CommentedFileConfig openFile(Path path) {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
    }

    private static void writeToFile(CommentedFileConfig file, MemoryClientConfig config) {
        file.set("#", (Object)"Memory - Client Config");
        file.set("#1", (Object)"Controls automatic screenshot cadence and notification visibility.");
        file.set("interval_seconds", (Object)config.intervalSeconds);
        file.setComment("interval_seconds", "Time between screenshots in seconds (default 300 = 5 minutes). Minimum 1.");
        file.set("show_screenshot_message", (Object)config.showScreenshotMessage);
        file.setComment("show_screenshot_message", "If true, show the vanilla chat message after each automatic screenshot.");
        file.save();
    }

    private static MemoryClientConfig normalized(int intervalSeconds, boolean showScreenshotMessage) {
        int sanitizedInterval = Math.max(1, intervalSeconds);
        return new MemoryClientConfig(sanitizedInterval, showScreenshotMessage);
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }
}

