/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.classicgamerule.translation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import me.fallenbreath.classicgamerule.ClassicGameruleMod;
import me.fallenbreath.classicgamerule.mixins.translation.ServerPlayerAccessor;
import me.fallenbreath.classicgamerule.mixins.translation.TranslatableContentsAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class Translations {
    private static final String DEFAULT_LANGUAGE = "en_us";
    private static final String RESOURCE_DIR = String.format("assets/%s/lang", "classicgamerule");
    private static final Map<String, Map<String, String>> translations = Maps.newLinkedHashMap();

    public static class_5250 translatable(class_2168 source, String key, Object ... args) {
        String formatter = Translations.translateKey(source, key);
        if (formatter == null) {
            ClassicGameruleMod.LOGGER.warn("Unknown translation key {}", (Object)key);
            return class_2561.method_43469((String)key, (Object[])args);
        }
        class_2588 translatableContents = (class_2588)class_2561.method_43469((String)formatter, (Object[])args).method_10851();
        ArrayList segments = Lists.newArrayList();
        ((TranslatableContentsAccessor)translatableContents).invokeDecomposeTemplate(formatter, segments::add);
        class_5250 msg = class_2561.method_43470((String)"");
        for (class_5348 segment : segments) {
            if (segment instanceof class_2561) {
                msg.method_10852((class_2561)segment);
                continue;
            }
            msg.method_10852((class_2561)class_2561.method_43470((String)segment.getString()));
        }
        return msg;
    }

    @Nullable
    private static String translateKey(class_2168 source, String key) {
        String formatter;
        String lang = DEFAULT_LANGUAGE;
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            lang = ((ServerPlayerAccessor)player).getLanguage();
        }
        if ((formatter = (String)translations.getOrDefault(lang, Collections.emptyMap()).get(key)) == null && !lang.equals(DEFAULT_LANGUAGE)) {
            formatter = (String)translations.getOrDefault(DEFAULT_LANGUAGE, Collections.emptyMap()).get(key);
        }
        return formatter;
    }

    private static String readResourceFileAsString(String path) throws IOException {
        InputStream inputStream = Translations.class.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Null input stream from path " + path);
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    public static void load() {
        try {
            LanguageList languageList = (LanguageList)new Gson().fromJson(Translations.readResourceFileAsString("%s/meta/languages.json".formatted(RESOURCE_DIR)), LanguageList.class);
            for (String lang : languageList) {
                TranslationMapping oneTranslation = (TranslationMapping)new Gson().fromJson(Translations.readResourceFileAsString("%s/%s.json".formatted(RESOURCE_DIR, lang)), TranslationMapping.class);
                translations.put(lang, oneTranslation);
            }
        }
        catch (IOException e) {
            ClassicGameruleMod.LOGGER.error("FATAL: Failed to load translations: {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    private static class LanguageList
    extends ArrayList<String> {
        private LanguageList() {
        }
    }

    private static class TranslationMapping
    extends LinkedHashMap<String, String> {
        private TranslationMapping() {
        }
    }
}

