/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.classicgamerule.core;

import com.mojang.brigadier.arguments.BoolArgumentType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.fallenbreath.classicgamerule.core.GameRuleMapping;
import me.fallenbreath.classicgamerule.translation.Translations;
import net.minecraft.class_12279;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

public class GameRuleMappings {
    public static final List<GameRuleMapping<?, ?>> MAPPINGS = Lists.newArrayList();

    private static <T> int performQuery(String classicName, class_12279<@NotNull T> gameRule, class_2168 source, T modernValue, T classicValue) {
        source.method_9226(() -> class_2561.method_43469((String)"commands.gamerule.query", (Object[])new Object[]{gameRule.method_76144(), gameRule.method_76146(modernValue)}), false);
        source.method_45068((class_2561)Translations.translatable(source, "classicgamerule.command.gamerule.query", classicName, gameRule.method_76146(classicValue)).method_27692(class_124.field_1080));
        return gameRule.method_76149(classicValue);
    }

    private static <T> int performSet(String classicName, class_12279<@NotNull T> gameRule, class_2168 source, T modernValue, T classicValue) {
        source.method_9225().method_64395().method_76186(gameRule, modernValue, source.method_9211());
        source.method_9226(() -> class_2561.method_43469((String)"commands.gamerule.set", (Object[])new Object[]{gameRule.method_76144(), gameRule.method_76146(modernValue)}), true);
        source.method_45068((class_2561)Translations.translatable(source, "classicgamerule.command.gamerule.set", classicName, gameRule.method_76146(classicValue)).method_27692(class_124.field_1080));
        return gameRule.method_76149(classicValue);
    }

    private static <T> void registerDefaultMapping(String classicName, class_12279<@NotNull T> gameRule) {
        MAPPINGS.add(new GameRuleMapping(classicName, gameRule, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Object ruleValue = source.method_9225().method_64395().method_76185(gameRule);
            return GameRuleMappings.performQuery(classicName, gameRule, source, ruleValue, ruleValue);
        }, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Object argValue = ctx.getArgument("value", gameRule.method_76151());
            return GameRuleMappings.performSet(classicName, gameRule, source, argValue, argValue);
        }, () -> gameRule.method_76154()));
    }

    private static void registerInvertedBooleanMapping(String classicName, class_12279<@NotNull Boolean> gameRule) {
        MAPPINGS.add(new GameRuleMapping(classicName, gameRule, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Boolean modernValue = (Boolean)source.method_9225().method_64395().method_76185(gameRule);
            Boolean classicValue = modernValue == false;
            return GameRuleMappings.performQuery(classicName, gameRule, source, modernValue, classicValue);
        }, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Boolean classicValue = (Boolean)ctx.getArgument("value", gameRule.method_76151());
            Boolean modernValue = classicValue == false;
            return GameRuleMappings.performSet(classicName, gameRule, source, classicValue, modernValue);
        }, () -> gameRule.method_76154()));
    }

    private static void registerFireTickMapping() {
        class_12279 gameRule = class_1928.field_56559;
        BiConsumer<String, Function> addRule = (classicName, classicValueMapper) -> MAPPINGS.add(new GameRuleMapping((String)classicName, class_1928.field_56559, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            int modernValue = (Integer)source.method_9225().method_64395().method_76185(gameRule);
            boolean classicValue = (Boolean)classicValueMapper.apply(modernValue);
            source.method_9226(() -> class_2561.method_43469((String)"commands.gamerule.query", (Object[])new Object[]{gameRule.method_76144(), gameRule.method_76146((Object)modernValue)}), false);
            source.method_45068((class_2561)Translations.translatable(source, "classicgamerule.command.gamerule.query", classicName, classicValue).method_27692(class_124.field_1080));
            return classicValue ? 1 : 0;
        }, ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            source.method_9213((class_2561)Translations.translatable(source, "classicgamerule.command.gamerule.set_disabled", classicName, gameRule.method_76144()));
            return 0;
        }, BoolArgumentType::bool));
        addRule.accept("doFireTick", modernValue -> modernValue != 0);
        addRule.accept("allowFireTicksAwayFromPlayer", modernValue -> modernValue == -1);
    }

    static {
        GameRuleMappings.registerDefaultMapping("allowEnteringNetherUsingPortals", class_1928.field_62435);
        GameRuleMappings.registerDefaultMapping("announceAdvancements", class_1928.field_19409);
        GameRuleMappings.registerDefaultMapping("blockExplosionDropDecay", class_1928.field_40880);
        GameRuleMappings.registerDefaultMapping("commandBlockOutput", class_1928.field_19394);
        GameRuleMappings.registerDefaultMapping("commandBlocksEnabled", class_1928.field_62916);
        GameRuleMappings.registerDefaultMapping("commandModificationBlockLimit", class_1928.field_41766);
        GameRuleMappings.registerInvertedBooleanMapping("disableElytraMovementCheck", (class_12279<Boolean>)class_1928.field_19404);
        GameRuleMappings.registerInvertedBooleanMapping("disablePlayerMovementCheck", (class_12279<Boolean>)class_1928.field_54909);
        GameRuleMappings.registerInvertedBooleanMapping("disableRaids", (class_12279<Boolean>)class_1928.field_19422);
        GameRuleMappings.registerDefaultMapping("doDaylightCycle", class_1928.field_19396);
        GameRuleMappings.registerDefaultMapping("doEntityDrops", class_1928.field_19393);
        GameRuleMappings.registerDefaultMapping("doImmediateRespawn", class_1928.field_20638);
        GameRuleMappings.registerDefaultMapping("doInsomnia", class_1928.field_20637);
        GameRuleMappings.registerDefaultMapping("doLimitedCrafting", class_1928.field_19407);
        GameRuleMappings.registerDefaultMapping("doMobLoot", class_1928.field_19391);
        GameRuleMappings.registerDefaultMapping("doMobSpawning", class_1928.field_19390);
        GameRuleMappings.registerDefaultMapping("doPatrolSpawning", class_1928.field_21831);
        GameRuleMappings.registerDefaultMapping("doTileDrops", class_1928.field_19392);
        GameRuleMappings.registerDefaultMapping("doTraderSpawning", class_1928.field_21832);
        GameRuleMappings.registerDefaultMapping("doVinesSpread", class_1928.field_42474);
        GameRuleMappings.registerDefaultMapping("doWardenSpawning", class_1928.field_38975);
        GameRuleMappings.registerDefaultMapping("doWeatherCycle", class_1928.field_19406);
        GameRuleMappings.registerDefaultMapping("drowningDamage", class_1928.field_20634);
        GameRuleMappings.registerDefaultMapping("enderPearlsVanishOnDeath", class_1928.field_46176);
        GameRuleMappings.registerDefaultMapping("fallDamage", class_1928.field_20635);
        GameRuleMappings.registerDefaultMapping("fireDamage", class_1928.field_20636);
        GameRuleMappings.registerDefaultMapping("forgiveDeadPlayers", class_1928.field_25401);
        GameRuleMappings.registerDefaultMapping("freezeDamage", class_1928.field_28044);
        GameRuleMappings.registerDefaultMapping("globalSoundEvents", class_1928.field_40886);
        GameRuleMappings.registerDefaultMapping("keepInventory", class_1928.field_19389);
        GameRuleMappings.registerDefaultMapping("lavaSourceConversion", class_1928.field_40885);
        GameRuleMappings.registerDefaultMapping("locatorBar", class_1928.field_59751);
        GameRuleMappings.registerDefaultMapping("logAdminCommands", class_1928.field_19397);
        GameRuleMappings.registerDefaultMapping("maxCommandChainLength", class_1928.field_19408);
        GameRuleMappings.registerDefaultMapping("maxCommandForkCount", class_1928.field_46658);
        GameRuleMappings.registerDefaultMapping("maxEntityCramming", class_1928.field_19405);
        GameRuleMappings.registerDefaultMapping("minecartMaxSpeed", class_1928.field_52614);
        GameRuleMappings.registerDefaultMapping("mobExplosionDropDecay", class_1928.field_40881);
        GameRuleMappings.registerDefaultMapping("naturalRegeneration", class_1928.field_19395);
        GameRuleMappings.registerDefaultMapping("playersNetherPortalCreativeDelay", class_1928.field_46795);
        GameRuleMappings.registerDefaultMapping("playersNetherPortalDefaultDelay", class_1928.field_46794);
        GameRuleMappings.registerDefaultMapping("playersSleepingPercentage", class_1928.field_28357);
        GameRuleMappings.registerDefaultMapping("projectilesCanBreakBlocks", class_1928.field_46796);
        GameRuleMappings.registerDefaultMapping("reducedDebugInfo", class_1928.field_19401);
        GameRuleMappings.registerDefaultMapping("sendCommandFeedback", class_1928.field_19400);
        GameRuleMappings.registerDefaultMapping("showDeathMessages", class_1928.field_19398);
        GameRuleMappings.registerDefaultMapping("snowAccumulationHeight", class_1928.field_40883);
        GameRuleMappings.registerDefaultMapping("spawnerBlocksEnabled", class_1928.field_62917);
        GameRuleMappings.registerDefaultMapping("spawnMonsters", class_1928.field_62436);
        GameRuleMappings.registerDefaultMapping("spawnRadius", class_1928.field_19403);
        GameRuleMappings.registerDefaultMapping("spectatorsGenerateChunks", class_1928.field_19402);
        GameRuleMappings.registerDefaultMapping("tntExplodes", class_1928.field_58052);
        GameRuleMappings.registerDefaultMapping("tntExplosionDropDecay", class_1928.field_40882);
        GameRuleMappings.registerDefaultMapping("universalAnger", class_1928.field_25402);
        GameRuleMappings.registerDefaultMapping("waterSourceConversion", class_1928.field_40884);
        GameRuleMappings.registerFireTickMapping();
    }
}

