package com.chyzman.wearthat.mixin;

import com.chyzman.wearthat.pond.ModelPartDuck;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.class_10034;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9331;
import net.minecraft.class_970;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_970.class)
public abstract class ArmorFeatureRendererMixin<S extends class_10034, M extends class_572<S>, A extends class_572<S>> extends class_3887<S, M> {

    @Shadow
    protected abstract A getModel(S state, class_1304 slot);

    @Shadow protected abstract void setVisible(A bipedModel, class_1304 slot);

    @Unique
    @Nullable
    private S renderState;

    public ArmorFeatureRendererMixin(class_3883<S, M> context) {
        super(context);
    }

    @WrapMethod(
        method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/BipedEntityRenderState;FF)V"
    )
    private void captureRenderState(
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        S state,
        float limbAngle,
        float limbDistance,
        Operation<S> original
    ) {
        this.renderState = state;
        original.call(matrices, vertexConsumers, light, state, limbAngle, limbDistance);
        this.renderState = null;
    }

    @SuppressWarnings("unchecked")
    @WrapOperation(
        method = "renderArmor",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/item/ItemStack;get(Lnet/minecraft/component/ComponentType;)Ljava/lang/Object;",
            ordinal = 0
        )
    )
    private Object renderWearThatedItems(
        class_1799 stack,
        class_9331<?> componentType,
        Operation<Object> original,
        @Local(argsOnly = true) class_4587 matrices,
        @Local(argsOnly = true) class_4597 vertexConsumers,
        @Local(argsOnly = true) class_1304 slot,
        @Local(argsOnly = true) int light,
        @Local(argsOnly = true) LocalRef<class_572<class_10034>> armorModelRef
    ) {
        var returned = original.call(stack, componentType);
        var modelIsEmpty = false;
        if(returned instanceof class_10192 component) {
            if (this.renderState != null) armorModelRef.set((class_572<class_10034>) getModel(this.renderState, component.comp_3174()));
            modelIsEmpty = component.comp_3176().isEmpty();
        }
        if (returned == null || modelIsEmpty) {
            var armorModel = armorModelRef.get();
            setVisible((A) armorModel, slot);
            var itemRenderer = class_310.method_1551().method_1480();
            var mode = class_811.field_4319;
            var model = itemRenderer.method_4019(stack, null, null, 0);
            var contextModel = this.method_17165();
            matrices.method_22903();
            contextModel.method_63512().method_22703(matrices);
            //@formatter:off
            switch (slot) {
                case field_6174 -> {
                    //torso
                    if (armorModel.field_3391.field_3665) {
                        matrices.method_22903();
                        contextModel.field_3391.method_22703(matrices);
                        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                        matrices.method_46416(0, -1 / 4f, 0);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        matrices.method_46416(0, -1 / 4f, 0);
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22909();
                    }

                    //right arm
                    if (armorModel.field_3401.field_3665) {
                        matrices.method_22903();
                        contextModel.field_3401.method_22703(matrices);
                        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                        matrices.method_22905(2 / 3f, 2 / 3f, 2 / 3f);
                        matrices.method_46416(-1 / 12f, 0, 0);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22905(0.99f, 0.99f, 0.99f);
                        matrices.method_46416(0, -1 / 2f, 0);
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22909();
                    }

                    //left arm
                    if (armorModel.field_27433.field_3665) {
                        matrices.method_22903();
                        contextModel.field_27433.method_22703(matrices);
                        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                        matrices.method_22905(2 / 3f, 2 / 3f, 2 / 3f);
                        matrices.method_46416(1 / 12f, 0, 0);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22905(0.99f, 0.99f, 0.99f);
                        matrices.method_46416(0, -1 / 2f, 0);
                        itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                        matrices.method_22909();
                    }
                }

                case field_6172 -> {
                    //right leg
                    matrices.method_22903();
                    contextModel.field_3392.method_22703(matrices);
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                    matrices.method_22905(2 / 3f, 2 / 3f, 2 / 3f);
                    matrices.method_46416(0, -1 / 6f, 0);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22905(1.01f, 1.01f, 1.01f);
                    matrices.method_46416(0, -1 / 3f, 0);
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22909();

                    //left leg
                    matrices.method_22903();
                    contextModel.field_3397.method_22703(matrices);
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                    matrices.method_22905(2 / 3f, 2 / 3f, 2 / 3f);
                    matrices.method_46416(0, -1 / 6f, 0);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22905(1.01f, 1.01f, 1.01f);
                    matrices.method_46416(0, -1 / 3f, 0);
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22909();
                }
                case field_6166 -> {
                    //right foot
                    matrices.method_22903();
                    contextModel.field_3392.method_22703(matrices);
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                    matrices.method_22905(0.75f, 0.75f, 0.75f);
                    matrices.method_46416(0, -0.8f, 0);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22909();

                    //left foot
                    matrices.method_22903();
                    contextModel.field_3397.method_22703(matrices);
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                    matrices.method_22905(0.75f, 0.75f, 0.75f);
                    matrices.method_46416(0, -0.8f, 0);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
                    itemRenderer.method_23179(stack, mode, true, matrices, vertexConsumers, light, class_4608.field_21444, model);
                    matrices.method_22909();
                }
            }
            //@formatter:on
            matrices.method_22909();
        }
        return returned;
    }

    @ModifyExpressionValue(
        method = "hasModel(Lnet/minecraft/component/type/EquippableComponent;Lnet/minecraft/entity/EquipmentSlot;)Z",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/component/type/EquippableComponent;slot()Lnet/minecraft/entity/EquipmentSlot;"
        )
    )
    private static class_1304 allArmorHasModels(
        class_1304 original,
        @Local(argsOnly = true) class_1304 slot
    ) {
        return slot;
    }

    @WrapOperation(
        method = "renderArmor",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;setVisible(Lnet/minecraft/client/render/entity/model/BipedEntityModel;Lnet/minecraft/entity/EquipmentSlot;)V"
        )
    )
    private void applyPostVisibility(
        class_970<S, M, A> instance,
        A bipedModel,
        class_1304 slot,
        Operation<Void> original,
        @Share("postVisibility") LocalRef<@Nullable Runnable> postVisibilityCallback
    ) {
        original.call(instance, bipedModel, slot);
        var postVisibility = postVisibilityCallback.get();
        if (postVisibility != null) {
            postVisibility.run();
            postVisibilityCallback.set(null);
        }
    }

    @ModifyExpressionValue(
        method = "renderArmor",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/entity/feature/ArmorFeatureRenderer;hasModel(Lnet/minecraft/component/type/EquippableComponent;Lnet/minecraft/entity/EquipmentSlot;)Z"
        )
    )
    private boolean modifySlot(
        boolean original,
        @Local() class_10192 component,
        @Local(argsOnly = true) LocalRef<class_1304> slotRef,
        @Share("originalSlot") LocalRef<@Nullable class_1304> originalSlot
    ) {
        var slot = slotRef.get();
        originalSlot.set(slot != component.comp_3174() ? slot : null);
        slotRef.set(component.comp_3174());
        return original;
    }

    @WrapOperation(
        method = "renderArmor",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/render/entity/model/BipedEntityModel;copyTransforms(Lnet/minecraft/client/render/entity/model/BipedEntityModel;)V"
        )
    )
    private void applyFunnyTransforms(
        M contextModel,
        M armorModel,
        Operation<Void> original,
        @Local(argsOnly = true) class_1304 slot,
        @Share("originalSlot") LocalRef<@Nullable class_1304> originalSlotRef,
        @Share("postVisibility") LocalRef<@Nullable Runnable> postVisibilityCallback
    ) {
        armorModel.method_63512().method_41923();
        armorModel.method_63513().forEach(modelPart -> ((ModelPartDuck) (Object) modelPart).wearThat$setTransform(null));
        original.call(contextModel, armorModel);
        var originalSlot = originalSlotRef.get();
        if (originalSlot == null) return;
        armorModel.method_63514();
        switch (originalSlot) {
            case field_6169 -> {
                armorModel.method_63512().method_17138(contextModel.method_2838());
                switch (slot) {
                    case field_6174 -> {
                        armorModel.field_3391.method_41920(new Vector3f(0, -20, 0));
                        armorModel.field_3401.method_41920(new Vector3f(-1, -20, 0));
                        armorModel.field_3401.method_41924(new Vector3f(0.001f, 0.001f, 0.001f));
                        armorModel.field_27433.method_41920(new Vector3f(1, -20, 0));
                        armorModel.field_27433.method_41924(new Vector3f(0.001f, 0.001f, 0.001f));
                    }
                    case field_6172 -> {
                        armorModel.method_63512().method_62132(class_7833.field_40718.rotationDegrees(180));
                    }
                    case field_6166 -> {
                        armorModel.field_3392.method_41920(new Vector3f(-1, -32, 0));
                        armorModel.field_3397.method_41920(new Vector3f(1, -32, 0));
                    }
                }
            }
            case field_6174 -> {
                switch (slot) {
                    case field_6169 -> {
                        armorModel.field_3398.method_17138(contextModel.field_3391);
                        ((ModelPartDuck) (Object) armorModel.field_3398).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(-90));
                            matrices.method_22905(1.25f, 1.25f, 1.25f);
                            matrices.method_46416(0, 4, 4);
                        });
                    }
                    case field_6172 -> {
                        //middle part
                        armorModel.field_3391.method_17138(contextModel.field_3391);
                        ((ModelPartDuck) (Object) armorModel.field_3391).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40718.rotationDegrees(180));
                            matrices.method_46416(0, -12, 0);
                        });

                        //right leg
                        armorModel.field_3392.method_17138(contextModel.field_3401);
                        armorModel.field_3392.method_41920(new Vector3f(-1f, 0.1f, 0));

                        //left leg
                        armorModel.field_3397.method_17138(contextModel.field_27433);
                        armorModel.field_3397.method_41920(new Vector3f(1f, 0.1f, 0));
                    }
                    case field_6166 -> {
                        //right boot
                        armorModel.field_3392.method_17138(contextModel.field_3401);
                        ((ModelPartDuck) (Object) armorModel.field_3392).wearThat$setTransform(matrices -> {
                            matrices.method_46416(-1, -1, 0);
                            matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        });

                        //left boot
                        armorModel.field_3397.method_17138(contextModel.field_27433);
                        ((ModelPartDuck) (Object) armorModel.field_3397).wearThat$setTransform(matrices -> {
                            matrices.method_46416(1, -1, 0);
                            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90));
                        });
                    }
                }
            }
            case field_6172 -> {
                switch (slot) {
                    case field_6169 -> {
                        armorModel.field_3398.method_17138(contextModel.field_3391);
                        ((ModelPartDuck) (Object) armorModel.field_3398).wearThat$setTransform(matrices -> {
                            matrices.method_46416(0, 18, 0);
                        });
                    }
                    case field_6174 -> {
                        //middle part
                        armorModel.field_3391.method_17138(contextModel.field_3391);
                        ((ModelPartDuck) (Object) armorModel.field_3391).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40718.rotationDegrees(180));
                            matrices.method_46416(0, -12, 0);
                        });

                        //right sleeve
                        armorModel.field_3401.method_17138(contextModel.field_3392);

                        //left sleeve
                        armorModel.field_27433.method_17138(contextModel.field_3397);
                    }
                    case field_6166 -> {
                        //right boot
                        armorModel.field_3392.method_17138(contextModel.field_3392);
                        ((ModelPartDuck) (Object) armorModel.field_3392).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                            matrices.method_46416(0, -10, 0);
                        });

                        //left boot
                        armorModel.field_3397.method_17138(contextModel.field_3397);
                        ((ModelPartDuck) (Object) armorModel.field_3397).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                            matrices.method_46416(0, -10, 0);
                        });
                    }
                }
            }
            case field_6166 -> {
                switch (slot) {
                    case field_6169 -> {
                        armorModel.field_3398.method_17138(contextModel.field_3397);
                        ((ModelPartDuck) (Object) armorModel.field_3398).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40718.rotationDegrees(180));
                            matrices.method_22905(0.75f, 0.75f, 0.75f);
                            matrices.method_46416(0, -7, 0);
                        });
                    }
                    case field_6174 -> {
                        //middle part
                        postVisibilityCallback.set(() -> armorModel.field_3391.field_3665 = false);

                        //right sleeve
                        armorModel.field_3401.method_17138(contextModel.field_3392);
                        ((ModelPartDuck) (Object) armorModel.field_3401).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                            matrices.method_46416(1, -9, 0);
                        });

                        //left sleeve
                        armorModel.field_27433.method_17138(contextModel.field_3397);
                        ((ModelPartDuck) (Object) armorModel.field_27433).wearThat$setTransform(matrices -> {
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
                            matrices.method_46416(-1, -9, 0);
                        });
                    }
                    case field_6172 -> {
                        //middle part
                        postVisibilityCallback.set(() -> armorModel.field_3391.field_3665 = false);

                        //right leg
                        armorModel.field_3392.method_17138(contextModel.field_3392);
                        ((ModelPartDuck) (Object) armorModel.field_3392).wearThat$setTransform(matrices -> {
                            matrices.method_46416(0, 3, 0);
                            matrices.method_22905(1.001f, 1.001f, 1.001f);
                        });

                        //left leg
                        armorModel.field_3397.method_17138(contextModel.field_3397);
                        ((ModelPartDuck) (Object) armorModel.field_3397).wearThat$setTransform(matrices -> {
                            matrices.method_46416(0, 3, 0);
                            matrices.method_22905(1.001f, 1.001f, 1.001f);
                        });
                    }
                }
            }
        }
        originalSlotRef.set(null);
    }
}
