package com.chyzman.wearthat.mixin;

import com.chyzman.wearthat.pond.ModelPartDuck;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.function.Consumer;
import net.minecraft.class_4587;
import net.minecraft.class_630;

@Mixin(class_630.class)
public abstract class ModelPartMixin implements ModelPartDuck {
    @Unique
    private Consumer<class_4587> transform = null;

    @Override
    public void wearThat$setTransform(Consumer<class_4587> consumer) {
        this.transform = consumer;
    }

    @WrapOperation(
        method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;III)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/model/ModelPart;rotate(Lnet/minecraft/client/util/math/MatrixStack;)V"
        )
    )
    private void applyTransform(
        class_630 instance,
        class_4587 matrices,
        Operation<Void> original
    ) {
        original.call(instance, matrices);
        if (this.transform != null) {
            matrices.method_22905(1/16f, 1/16f, 1/16f);
            this.transform.accept(matrices);
            matrices.method_22905(16, 16, 16);
        }
    }
}
