/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultimine_rewind.menu.RewindMenu;
import com.ultimine_rewind.network.ConfirmRewindPacket;
import com.ultimine_rewind.network.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RewindScreen
extends AbstractContainerScreen<RewindMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    private Button confirmButton;
    private Button cancelButton;
    private Button detailsButton;
    private List<Component> requiredItemsText;
    private final int containerRows = 6;
    private boolean showDetails = false;

    public RewindScreen(RewindMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonX = this.f_97735_ + this.f_97726_ + 5;
        int buttonWidth = 80;
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.ultimine_rewind.button.restore"), btn -> this.onConfirmClicked()).m_252987_(buttonX, this.f_97736_ + 20, buttonWidth, 30).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.ultimine_rewind.button.cancel"), btn -> this.m_7379_()).m_252987_(buttonX, this.f_97736_ + 55, buttonWidth, 30).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.updateRequiredItemsText();
    }

    private void toggleDetails() {
        this.showDetails = !this.showDetails;
    }

    private void updateRequiredItemsText() {
        boolean isCreative;
        this.requiredItemsText = new ArrayList<Component>();
        boolean bl = isCreative = this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.m_7500_();
        if (isCreative) {
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.creative_mode").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.creative_no_materials").m_130940_(ChatFormatting.GREEN));
            this.requiredItemsText.add((Component)Component.m_237113_((String)""));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.creative_click_restore").m_130940_(ChatFormatting.GRAY));
        } else if (((RewindMenu)this.f_97732_).hasData()) {
            Map<Item, Integer> required = ((RewindMenu)this.f_97732_).getRequiredItems();
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.required_items").m_130940_(ChatFormatting.BOLD));
            this.requiredItemsText.add((Component)Component.m_237110_((String)"gui.ultimine_rewind.material_count", (Object[])new Object[]{required.size()}).m_130940_(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.click_for_details").m_130940_(ChatFormatting.GRAY));
        } else {
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.rewind_hint").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            this.requiredItemsText.add((Component)Component.m_237113_((String)""));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.place_blocks").m_130940_(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.into_container").m_130940_(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.m_237113_((String)""));
            this.requiredItemsText.add((Component)Component.m_237115_((String)"gui.ultimine_rewind.creative_no_cost").m_130940_(ChatFormatting.GREEN));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.requiredItemsText != null && !this.requiredItemsText.isEmpty()) {
            int panelX = this.f_97735_ - 160;
            int panelY = this.f_97736_;
            int panelWidth = 150;
            int panelHeight = this.f_97727_;
            guiGraphics.m_280509_(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -587202560);
            guiGraphics.m_280509_(panelX, panelY, panelX + panelWidth, panelY + 1, -5592406);
            guiGraphics.m_280509_(panelX, panelY, panelX + 1, panelY + panelHeight, -5592406);
            guiGraphics.m_280509_(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, -11184811);
            guiGraphics.m_280509_(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, -11184811);
            MutableComponent panelTitle = Component.m_237115_((String)"gui.ultimine_rewind.panel_title").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
            int titleWidth = this.f_96547_.m_92852_((FormattedText)panelTitle);
            guiGraphics.m_280430_(this.f_96547_, (Component)panelTitle, panelX + (panelWidth - titleWidth) / 2, panelY + 8, 0xFFFFFF);
            guiGraphics.m_280509_(panelX + 5, panelY + 20, panelX + panelWidth - 5, panelY + 21, -7829368);
            int textY = panelY + 28;
            for (Component text : this.requiredItemsText) {
                guiGraphics.m_280430_(this.f_96547_, text, panelX + 8, textY, 0xFFFFFF);
                textY += 12;
            }
            int buttonY = textY + 10;
            int buttonHeight = 20;
            if (this.detailsButton != null) {
                this.m_169411_((GuiEventListener)this.detailsButton);
            }
            this.detailsButton = Button.m_253074_((Component)(this.showDetails ? Component.m_237115_((String)"gui.ultimine_rewind.button.close_details") : Component.m_237115_((String)"gui.ultimine_rewind.button.view_materials")), btn -> this.toggleDetails()).m_252987_(panelX + 5, buttonY, panelWidth - 10, buttonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.detailsButton);
            if (this.showDetails) {
                int detailY = buttonY + buttonHeight + 10;
                guiGraphics.m_280509_(panelX + 5, detailY - 5, panelX + panelWidth - 5, detailY - 4, -7829368);
                if (((RewindMenu)this.f_97732_).hasData()) {
                    Map<Item, Integer> required = ((RewindMenu)this.f_97732_).getRequiredItems();
                    for (Map.Entry<Item, Integer> entry : required.entrySet()) {
                        guiGraphics.m_280480_(new ItemStack((ItemLike)entry.getKey()), panelX + 10, detailY);
                        Component itemName = entry.getKey().m_41466_();
                        String text = itemName.getString() + " x" + entry.getValue();
                        guiGraphics.m_280488_(this.f_96547_, text, panelX + 30, detailY + 4, 0xFFFFFF);
                        if ((detailY += 20) <= panelY + panelHeight - 10) continue;
                        guiGraphics.m_280488_(this.f_96547_, "...", panelX + 10, detailY, -7829368);
                        break;
                    }
                } else {
                    guiGraphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.ultimine_rewind.material_info").getString(), panelX + 10, detailY, 0xFFFFFF);
                    guiGraphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.ultimine_rewind.auto_display").getString(), panelX + 10, detailY += 15, -7829368);
                    guiGraphics.m_280488_(this.f_96547_, Component.m_237115_((String)"gui.ultimine_rewind.auto_display_2").getString(), panelX + 10, detailY += 12, -7829368);
                }
            }
        }
        this.confirmButton.f_93623_ = ((RewindMenu)this.f_97732_).record == null ? true : ((RewindMenu)this.f_97732_).validateItems();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, 125);
        guiGraphics.m_280218_(TEXTURE, x, y + 108 + 17, 0, 126, this.f_97726_, 96);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    private void onConfirmClicked() {
        NetworkHandler.INSTANCE.sendToServer((Object)new ConfirmRewindPacket());
        this.m_7379_();
    }
}

