/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.logic;

import com.ultimine_rewind.data.BlockRecord;
import com.ultimine_rewind.data.RewindDataManager;
import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;

public class RewindExecutor {
    public static boolean executeRewind(ServerPlayer player, RewindMenu menu) {
        UltimineRecord record = menu.record;
        if (record == null) {
            return false;
        }
        ServerLevel level = player.m_284548_();
        boolean isCreative = player.m_7500_();
        if (!menu.validateItems()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.ultimine_rewind.no_materials").m_130940_(ChatFormatting.RED), false);
            return false;
        }
        int restorableCount = menu.getRestorableBlockCount();
        if (restorableCount <= 0 && !isCreative) {
            player.m_5661_((Component)Component.m_237115_((String)"message.ultimine_rewind.insufficient_materials").m_130940_(ChatFormatting.RED), false);
            return false;
        }
        int blocksToRestore = isCreative ? record.getBlockCount() : Math.min(restorableCount, record.getBlockCount());
        List<BlockRecord> blocksToProcess = record.getBlocks().subList(0, blocksToRestore);
        for (BlockRecord blockRecord : blocksToProcess) {
            BlockState currentState;
            BlockPos pos = blockRecord.getPos();
            if (level.m_46749_(pos) && !(currentState = level.m_8055_(pos)).m_60795_() && currentState.m_247087_()) continue;
        }
        int restoredCount = 0;
        for (BlockRecord blockRecord : blocksToProcess) {
            BlockState currentState;
            BlockPos pos = blockRecord.getPos();
            BlockState state = blockRecord.getState();
            if (!level.m_46749_(pos) || !(currentState = level.m_8055_(pos)).m_60795_() && !currentState.m_247087_()) continue;
            level.m_7731_(pos, state, 3);
            ++restoredCount;
        }
        menu.consumeItemsAndReturnRest(restoredCount);
        int n = record.getBlockCount();
        if (restoredCount < n) {
            UltimineRecord newRecord = record.removeRestoredBlocks(restoredCount);
            RewindDataManager.updateRecord(player.m_20148_(), newRecord);
            int remaining = n - restoredCount;
            player.m_5661_((Component)Component.m_237110_((String)"message.ultimine_rewind.partial_restore", (Object[])new Object[]{restoredCount, n}).m_130940_(ChatFormatting.YELLOW), false);
            player.m_5661_((Component)Component.m_237110_((String)"message.ultimine_rewind.remaining", (Object[])new Object[]{remaining}).m_130940_(ChatFormatting.GRAY), true);
        } else {
            RewindDataManager.clearRecord(player.m_20148_());
            if (isCreative) {
                player.m_5661_((Component)Component.m_237110_((String)"message.ultimine_rewind.success_creative", (Object[])new Object[]{restoredCount}).m_130940_(ChatFormatting.GREEN), false);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"message.ultimine_rewind.success", (Object[])new Object[]{restoredCount}).m_130940_(ChatFormatting.GREEN), false);
            }
        }
        return true;
    }
}

