/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.network;

import com.ultimine_rewind.data.RewindDataManager;
import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import com.ultimine_rewind.network.NetworkHandler;
import com.ultimine_rewind.network.SyncRecordPacket;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OpenRewindScreenPacket {
    public static void encode(OpenRewindScreenPacket packet, FriendlyByteBuf buf) {
    }

    public static OpenRewindScreenPacket decode(FriendlyByteBuf buf) {
        return new OpenRewindScreenPacket();
    }

    public static void handle(OpenRewindScreenPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            UltimineRecord record = RewindDataManager.getRecord(player.m_20148_());
            if (record == null) {
                player.m_5661_((Component)Component.m_237115_((String)"message.ultimine_rewind.no_record").m_130940_(ChatFormatting.RED), true);
                return;
            }
            UltimineRecord finalRecord = record;
            player.m_5893_((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, p) -> new RewindMenu(containerId, playerInventory, finalRecord), (Component)Component.m_237115_((String)"container.ultimine_rewind.rewind_menu")));
            if (record != null) {
                NetworkHandler.INSTANCE.sendTo((Object)new SyncRecordPacket(record), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        context.setPacketHandled(true);
    }
}

