/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.network;

import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class SyncRecordPacket {
    private final Map<Item, Integer> requiredItems;
    private final int blockCount;

    public SyncRecordPacket(UltimineRecord record) {
        this.requiredItems = record != null ? record.getRequiredItems() : new HashMap<Item, Integer>();
        this.blockCount = record != null ? record.getBlockCount() : 0;
    }

    public SyncRecordPacket(Map<Item, Integer> requiredItems, int blockCount) {
        this.requiredItems = requiredItems;
        this.blockCount = blockCount;
    }

    public static void encode(SyncRecordPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.blockCount);
        buf.writeInt(packet.requiredItems.size());
        for (Map.Entry<Item, Integer> entry : packet.requiredItems.entrySet()) {
            buf.writeInt(Item.m_41393_((Item)entry.getKey()));
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public static SyncRecordPacket decode(FriendlyByteBuf buf) {
        int blockCount = buf.readInt();
        int mapSize = buf.readInt();
        HashMap<Item, Integer> requiredItems = new HashMap<Item, Integer>();
        for (int i = 0; i < mapSize; ++i) {
            int itemId = buf.readInt();
            int count = buf.readInt();
            Item item = Item.m_41445_((int)itemId);
            if (item == null) continue;
            requiredItems.put(item, count);
        }
        return new SyncRecordPacket(requiredItems, blockCount);
    }

    public static void handle(SyncRecordPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2344$temp;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null && (patt2344$temp = minecraft.f_91074_.f_36096_) instanceof RewindMenu) {
                RewindMenu menu = (RewindMenu)patt2344$temp;
                menu.setClientRecordData(packet.requiredItems, packet.blockCount);
            }
        });
        context.setPacketHandled(true);
    }
}

