/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultimine_rewind.menu.RewindMenu;
import com.ultimine_rewind.network.ConfirmRewindPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class RewindScreen
extends AbstractContainerScreen<RewindMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private Button confirmButton;
    private Button cancelButton;
    private Button detailsButton;
    private List<Component> requiredItemsText;
    private final int containerRows = 6;
    private boolean showDetails = false;

    public RewindScreen(RewindMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        int buttonX = this.leftPos + this.imageWidth + 5;
        int buttonWidth = 80;
        this.confirmButton = Button.builder((Component)Component.translatable((String)"gui.ultimine_rewind.button.restore"), btn -> this.onConfirmClicked()).bounds(buttonX, this.topPos + 20, buttonWidth, 30).build();
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.builder((Component)Component.translatable((String)"gui.ultimine_rewind.button.cancel"), btn -> this.onClose()).bounds(buttonX, this.topPos + 55, buttonWidth, 30).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.updateRequiredItemsText();
    }

    private void toggleDetails() {
        this.showDetails = !this.showDetails;
    }

    private void updateRequiredItemsText() {
        boolean isCreative;
        this.requiredItemsText = new ArrayList<Component>();
        boolean bl = isCreative = this.minecraft != null && this.minecraft.player != null && this.minecraft.player.isCreative();
        if (isCreative) {
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.creative_mode").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.creative_no_materials").withStyle(ChatFormatting.GREEN));
            this.requiredItemsText.add((Component)Component.literal((String)""));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.creative_click_restore").withStyle(ChatFormatting.GRAY));
        } else if (((RewindMenu)this.menu).hasData()) {
            Map<Item, Integer> required = ((RewindMenu)this.menu).getRequiredItems();
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.required_items").withStyle(ChatFormatting.BOLD));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.material_count", (Object[])new Object[]{required.size()}).withStyle(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.click_for_details").withStyle(ChatFormatting.GRAY));
        } else {
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.rewind_hint").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            this.requiredItemsText.add((Component)Component.literal((String)""));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.place_blocks").withStyle(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.into_container").withStyle(ChatFormatting.GRAY));
            this.requiredItemsText.add((Component)Component.literal((String)""));
            this.requiredItemsText.add((Component)Component.translatable((String)"gui.ultimine_rewind.creative_no_cost").withStyle(ChatFormatting.GREEN));
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.requiredItemsText != null && !this.requiredItemsText.isEmpty()) {
            int panelX = this.leftPos - 160;
            int panelY = this.topPos;
            int panelWidth = 150;
            int panelHeight = this.imageHeight;
            guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -587202560);
            guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + 1, -5592406);
            guiGraphics.fill(panelX, panelY, panelX + 1, panelY + panelHeight, -5592406);
            guiGraphics.fill(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, -11184811);
            guiGraphics.fill(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, -11184811);
            MutableComponent panelTitle = Component.translatable((String)"gui.ultimine_rewind.panel_title").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
            int titleWidth = this.font.width((FormattedText)panelTitle);
            guiGraphics.drawString(this.font, (Component)panelTitle, panelX + (panelWidth - titleWidth) / 2, panelY + 8, 0xFFFFFF);
            guiGraphics.fill(panelX + 5, panelY + 20, panelX + panelWidth - 5, panelY + 21, -7829368);
            int textY = panelY + 28;
            for (Component text : this.requiredItemsText) {
                guiGraphics.drawString(this.font, text, panelX + 8, textY, 0xFFFFFF);
                textY += 12;
            }
            int buttonY = textY + 10;
            int buttonHeight = 20;
            if (this.detailsButton != null) {
                this.removeWidget((GuiEventListener)this.detailsButton);
            }
            this.detailsButton = Button.builder((Component)(this.showDetails ? Component.translatable((String)"gui.ultimine_rewind.button.close_details") : Component.translatable((String)"gui.ultimine_rewind.button.view_materials")), btn -> this.toggleDetails()).bounds(panelX + 5, buttonY, panelWidth - 10, buttonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.detailsButton);
            if (this.showDetails) {
                int detailY = buttonY + buttonHeight + 10;
                guiGraphics.fill(panelX + 5, detailY - 5, panelX + panelWidth - 5, detailY - 4, -7829368);
                if (((RewindMenu)this.menu).hasData()) {
                    Map<Item, Integer> required = ((RewindMenu)this.menu).getRequiredItems();
                    for (Map.Entry<Item, Integer> entry : required.entrySet()) {
                        guiGraphics.renderItem(new ItemStack((ItemLike)entry.getKey()), panelX + 10, detailY);
                        Component itemName = entry.getKey().getDescription();
                        String text = itemName.getString() + " x" + String.valueOf(entry.getValue());
                        guiGraphics.drawString(this.font, text, panelX + 30, detailY + 4, 0xFFFFFF);
                        if ((detailY += 20) <= panelY + panelHeight - 10) continue;
                        guiGraphics.drawString(this.font, "...", panelX + 10, detailY, -7829368);
                        break;
                    }
                } else {
                    guiGraphics.drawString(this.font, Component.translatable((String)"gui.ultimine_rewind.material_info").getString(), panelX + 10, detailY, 0xFFFFFF);
                    guiGraphics.drawString(this.font, Component.translatable((String)"gui.ultimine_rewind.auto_display").getString(), panelX + 10, detailY += 15, -7829368);
                    guiGraphics.drawString(this.font, Component.translatable((String)"gui.ultimine_rewind.auto_display_2").getString(), panelX + 10, detailY += 12, -7829368);
                }
            }
        }
        this.confirmButton.active = ((RewindMenu)this.menu).record == null ? true : ((RewindMenu)this.menu).validateItems();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, 125);
        guiGraphics.blit(TEXTURE, x, y + 108 + 17, 0, 126, this.imageWidth, 96);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    private void onConfirmClicked() {
        PacketDistributor.sendToServer((CustomPacketPayload)ConfirmRewindPacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }
}

