/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.data;

import com.ultimine_rewind.data.BlockRecord;
import com.ultimine_rewind.data.UltimineRecord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class RewindDataManager {
    private static final Map<UUID, UltimineRecord> playerRecords = new HashMap<UUID, UltimineRecord>();

    public static void recordUltimine(ServerPlayer player, List<BlockRecord> blocks, BlockPos centerPos) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        UUID playerId = player.getUUID();
        UltimineRecord record = new UltimineRecord(playerId, System.currentTimeMillis(), blocks, centerPos);
        playerRecords.put(playerId, record);
    }

    @Nullable
    public static UltimineRecord getRecord(UUID playerId) {
        UltimineRecord record = playerRecords.get(playerId);
        if (record != null && record.isExpired()) {
            playerRecords.remove(playerId);
            return null;
        }
        return record;
    }

    public static void clearRecord(UUID playerId) {
        playerRecords.remove(playerId);
    }

    public static void updateRecord(UUID playerId, UltimineRecord newRecord) {
        if (newRecord == null || newRecord.blocks().isEmpty()) {
            playerRecords.remove(playerId);
        } else {
            playerRecords.put(playerId, newRecord);
        }
    }

    public static void cleanupExpiredRecords() {
        playerRecords.entrySet().removeIf(entry -> ((UltimineRecord)entry.getValue()).isExpired());
    }

    public static boolean hasRecord(UUID playerId) {
        return RewindDataManager.getRecord(playerId) != null;
    }
}

