/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.data;

import com.ultimine_rewind.data.BlockRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record UltimineRecord(UUID playerId, long timestamp, List<BlockRecord> blocks, BlockPos centerPos) {
    private final List<BlockRecord> blocks;

    public UltimineRecord(UUID playerId, long timestamp, List<BlockRecord> blocks, BlockPos centerPos) {
        this.playerId = playerId;
        this.timestamp = timestamp;
        this.blocks = new ArrayList<BlockRecord>(blocks);
        this.centerPos = centerPos.immutable();
    }

    public List<BlockRecord> blocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public Map<Item, Integer> getRequiredItems() {
        HashMap<Item, Integer> items = new HashMap<Item, Integer>();
        for (BlockRecord record : this.blocks) {
            ItemStack stack = record.getRequiredItem();
            if (stack.isEmpty()) continue;
            items.merge(stack.getItem(), stack.getCount(), Integer::sum);
        }
        return items;
    }

    public boolean isExpired() {
        return this.isExpired(600000L);
    }

    public boolean isExpired(long expiryTimeMs) {
        return System.currentTimeMillis() - this.timestamp > expiryTimeMs;
    }

    public int getBlockCount() {
        return this.blocks.size();
    }

    public UltimineRecord removeRestoredBlocks(int count) {
        if (count >= this.blocks.size()) {
            return null;
        }
        ArrayList<BlockRecord> remainingBlocks = new ArrayList<BlockRecord>(this.blocks.subList(count, this.blocks.size()));
        return new UltimineRecord(this.playerId, this.timestamp, remainingBlocks, this.centerPos);
    }
}

