/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.logic;

import com.ultimine_rewind.data.BlockRecord;
import com.ultimine_rewind.data.RewindDataManager;
import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RewindExecutor {
    public static void executeRewind(Player player, RewindMenu menu) {
        UltimineRecord record = menu.record;
        if (record == null) {
            return;
        }
        ServerLevel level = Objects.requireNonNull(player.getServer()).overworld();
        boolean isCreative = player.isCreative();
        if (!menu.validateItems()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.no_materials").withStyle(ChatFormatting.RED), false);
            return;
        }
        int restorableCount = menu.getRestorableBlockCount();
        if (restorableCount <= 0 && !isCreative) {
            player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.insufficient_materials").withStyle(ChatFormatting.RED), false);
            return;
        }
        int blocksToRestore = isCreative ? record.getBlockCount() : Math.min(restorableCount, record.getBlockCount());
        List<BlockRecord> blocksToProcess = record.blocks().subList(0, blocksToRestore);
        for (BlockRecord blockRecord : blocksToProcess) {
            BlockState currentState;
            BlockPos pos = blockRecord.getPos();
            if (level.isLoaded(pos) && !(currentState = level.getBlockState(pos)).isAir() && currentState.canBeReplaced()) continue;
        }
        int restoredCount = 0;
        for (BlockRecord blockRecord : blocksToProcess) {
            BlockEntity blockEntity;
            BlockState currentState;
            BlockPos pos = blockRecord.getPos();
            BlockState state = blockRecord.getState();
            if (!level.isLoaded(pos) || !(currentState = level.getBlockState(pos)).isAir() && !currentState.canBeReplaced()) continue;
            level.setBlock(pos, state, 3);
            if (isCreative && blockRecord.getBlockEntityData() != null && (blockEntity = level.getBlockEntity(pos)) != null) {
                blockEntity.loadWithComponents(blockRecord.getBlockEntityData(), (HolderLookup.Provider)level.registryAccess());
                blockEntity.setChanged();
            }
            ++restoredCount;
        }
        menu.consumeItemsAndReturnRest(restoredCount);
        int n = record.getBlockCount();
        if (restoredCount < n) {
            UltimineRecord newRecord = record.removeRestoredBlocks(restoredCount);
            RewindDataManager.updateRecord(player.getUUID(), newRecord);
            int remaining = n - restoredCount;
            player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.partial_restore", (Object[])new Object[]{restoredCount, n}).withStyle(ChatFormatting.YELLOW), false);
            player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.remaining", (Object[])new Object[]{remaining}).withStyle(ChatFormatting.GRAY), true);
        } else {
            RewindDataManager.clearRecord(player.getUUID());
            if (isCreative) {
                player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.success_creative", (Object[])new Object[]{restoredCount}).withStyle(ChatFormatting.GREEN), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.success", (Object[])new Object[]{restoredCount}).withStyle(ChatFormatting.GREEN), false);
            }
        }
    }
}

