/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.menu;

import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.init.ModMenuTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RewindMenu
extends AbstractContainerMenu {
    private static final int CONTAINER_SIZE = 54;
    private static final int CONTAINER_ROWS = 6;
    private static final int CONTAINER_COLS = 9;
    public final UltimineRecord record;
    private final Container container;
    private final Player player;
    private Map<Item, Integer> clientRequiredItems;
    private int clientBlockCount;

    public RewindMenu(int containerId, Inventory playerInventory, UltimineRecord record) {
        super((MenuType)ModMenuTypes.REWIND_MENU.get(), containerId);
        int col;
        this.record = record;
        this.player = playerInventory.player;
        this.container = new SimpleContainer(54);
        for (int row = 0; row < 6; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.addSlot(new Slot(this.container, row * 9 + col2, 8 + col2 * 18, 18 + row * 18));
            }
        }
        int inventoryY = 140;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, inventoryY + row * 18));
            }
        }
        int hotbarY = inventoryY + 58;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, hotbarY));
        }
    }

    public RewindMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, null);
        this.clientRequiredItems = new HashMap<Item, Integer>();
        this.clientBlockCount = 0;
    }

    public void setClientRecordData(Map<Item, Integer> requiredItems, int blockCount) {
        this.clientRequiredItems = new HashMap<Item, Integer>(requiredItems);
        this.clientBlockCount = blockCount;
    }

    public Map<Item, Integer> getRequiredItems() {
        if (this.record != null) {
            return this.record.getRequiredItems();
        }
        return this.clientRequiredItems != null ? this.clientRequiredItems : new HashMap<Item, Integer>();
    }

    public int getBlockCount() {
        if (this.record != null) {
            return this.record.getBlockCount();
        }
        return this.clientBlockCount;
    }

    public boolean hasData() {
        if (this.record != null) {
            Map<Item, Integer> items = this.record.getRequiredItems();
            return !items.isEmpty();
        }
        return this.clientRequiredItems != null && !this.clientRequiredItems.isEmpty();
    }

    public boolean validateItems() {
        if (this.record == null) {
            return false;
        }
        if (this.player != null && this.player.isCreative()) {
            return true;
        }
        Map<Item, Integer> required = this.record.getRequiredItems();
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = this.getSlot(i).getItem();
            if (stack.isEmpty() || !required.containsKey(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public int getRestorableBlockCount() {
        if (this.record == null) {
            return 0;
        }
        if (this.player != null && this.player.isCreative()) {
            return this.record.getBlockCount();
        }
        HashMap<Item, Integer> provided = new HashMap<Item, Integer>();
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = this.getSlot(i).getItem();
            if (stack.isEmpty()) continue;
            provided.merge(stack.getItem(), stack.getCount(), Integer::sum);
        }
        Map<Item, Integer> required = this.record.getRequiredItems();
        int totalRequired = required.values().stream().mapToInt(Integer::intValue).sum();
        if (totalRequired == 0) {
            return 0;
        }
        int canRestore = Integer.MAX_VALUE;
        for (Map.Entry<Item, Integer> entry : required.entrySet()) {
            int need = entry.getValue();
            int have = provided.getOrDefault(entry.getKey(), 0);
            if (need <= 0) continue;
            int ratio = have * this.record.getBlockCount() / need;
            canRestore = Math.min(canRestore, ratio);
        }
        return canRestore == Integer.MAX_VALUE ? 0 : canRestore;
    }

    public void consumeItemsAndReturnRest(int actualRestoredCount) {
        if (this.record == null || this.player == null || this.player.level().isClientSide) {
            return;
        }
        if (this.player.isCreative()) {
            for (int i = 0; i < 54; ++i) {
                ItemStack stack = this.container.removeItemNoUpdate(i);
                if (stack.isEmpty()) continue;
                this.player.getInventory().placeItemBackInInventory(stack);
            }
            return;
        }
        int totalBlocks = this.record.getBlockCount();
        if (actualRestoredCount <= 0) {
            for (int i = 0; i < 54; ++i) {
                ItemStack stack = this.container.removeItemNoUpdate(i);
                if (stack.isEmpty()) continue;
                this.player.getInventory().placeItemBackInInventory(stack);
            }
            return;
        }
        Map<Item, Integer> originalRequired = this.record.getRequiredItems();
        HashMap<Item, Integer> actualConsume = new HashMap<Item, Integer>();
        for (Map.Entry<Item, Integer> entry : originalRequired.entrySet()) {
            int originalAmount = entry.getValue();
            int consumeAmount = originalAmount * actualRestoredCount / totalBlocks;
            actualConsume.put(entry.getKey(), consumeAmount);
        }
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = this.container.removeItemNoUpdate(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            int count = stack.getCount();
            Integer remainingNeed = (Integer)actualConsume.get(item);
            if (remainingNeed != null && remainingNeed > 0) {
                int toConsume = Math.min(remainingNeed, count);
                int toReturn = count - toConsume;
                actualConsume.put(item, remainingNeed - toConsume);
                if (toReturn <= 0) continue;
                ItemStack returnStack = new ItemStack((ItemLike)item, toReturn);
                if (this.player.getInventory().add(returnStack)) continue;
                this.player.drop(returnStack, false);
                continue;
            }
            if (this.player.getInventory().add(stack)) continue;
            this.player.drop(stack, false);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < 54 ? !this.moveItemStackTo(stack, 54, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            for (int i = 0; i < 54; ++i) {
                ItemStack stack = this.container.removeItemNoUpdate(i);
                if (stack.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

