/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.mixin;

import com.ultimine_rewind.data.BlockRecord;
import com.ultimine_rewind.data.RewindDataManager;
import dev.architectury.event.EventResult;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FTBUltimine.class}, remap=false)
public abstract class MixinFTBUltimine {
    @Shadow
    private boolean isBreakingBlock;
    @Unique
    private List<BlockRecord> ultimine_rewind$currentBlockRecords = null;
    @Unique
    private BlockPos ultimine_rewind$currentCenterPos = null;

    @Shadow
    public abstract FTBUltiminePlayerData getOrCreatePlayerData(Player var1);

    @Inject(method={"blockBroken"}, at={@At(value="FIELD", target="Ldev/ftb/mods/ftbultimine/FTBUltimine;isBreakingBlock:Z", ordinal=0, shift=At.Shift.BEFORE)}, remap=false)
    private void ultimine_rewind$onUltimineStart(Level world, BlockPos origPos, BlockState state, ServerPlayer player, IntValue xp, CallbackInfoReturnable<EventResult> cir) {
        if (world instanceof ServerLevel) {
            FTBUltiminePlayerData data;
            ServerLevel serverLevel = (ServerLevel)world;
            if (!this.isBreakingBlock && (data = this.getOrCreatePlayerData((Player)player)).hasCachedPositions()) {
                this.ultimine_rewind$currentBlockRecords = new ArrayList<BlockRecord>();
                this.ultimine_rewind$currentCenterPos = origPos.immutable();
                for (BlockPos pos : data.cachedPositions()) {
                    this.ultimine_rewind$recordBlock(serverLevel, pos);
                }
            }
        }
    }

    @Inject(method={"blockBroken"}, at={@At(value="FIELD", target="Ldev/ftb/mods/ftbultimine/FTBUltimine;isBreakingBlock:Z", ordinal=1, shift=At.Shift.AFTER)}, remap=false)
    private void ultimine_rewind$onUltimineEnd(Level world, BlockPos origPos, BlockState state, ServerPlayer player, @Nullable IntValue xp, CallbackInfoReturnable<EventResult> cir) {
        if (this.ultimine_rewind$currentBlockRecords != null && !this.ultimine_rewind$currentBlockRecords.isEmpty()) {
            RewindDataManager.recordUltimine(player, this.ultimine_rewind$currentBlockRecords, this.ultimine_rewind$currentCenterPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.recorded", (Object[])new Object[]{this.ultimine_rewind$currentBlockRecords.size()}).withStyle(ChatFormatting.GRAY), true);
            this.ultimine_rewind$currentBlockRecords = null;
            this.ultimine_rewind$currentCenterPos = null;
        }
    }

    @Unique
    private void ultimine_rewind$recordBlock(ServerLevel level, BlockPos pos) {
        if (this.ultimine_rewind$currentBlockRecords == null) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CompoundTag beData = null;
        if (blockEntity != null) {
            beData = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        }
        BlockRecord record = new BlockRecord(pos, blockState, beData);
        this.ultimine_rewind$currentBlockRecords.add(record);
    }
}

