/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.network;

import com.ultimine_rewind.data.RewindDataManager;
import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import com.ultimine_rewind.network.SyncRecordPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class OpenRewindScreenPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenRewindScreenPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ultimine_rewind", (String)"open_rewind_screen"));
    public static final OpenRewindScreenPacket INSTANCE = new OpenRewindScreenPacket();
    public static final StreamCodec<FriendlyByteBuf, OpenRewindScreenPacket> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private OpenRewindScreenPacket() {
    }

    public static void handle(OpenRewindScreenPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                UltimineRecord record = RewindDataManager.getRecord(player.getUUID());
                if (record == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.ultimine_rewind.no_record").withStyle(ChatFormatting.RED), true);
                    return;
                }
                player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, p) -> new RewindMenu(containerId, playerInventory, record), (Component)Component.translatable((String)"container.ultimine_rewind.rewind_menu")));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncRecordPacket.from(record), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

