/*
 * Decompiled with CFR 0.152.
 */
package com.ultimine_rewind.network;

import com.ultimine_rewind.data.UltimineRecord;
import com.ultimine_rewind.menu.RewindMenu;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncRecordPacket(Map<Item, Integer> requiredItems, int blockCount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncRecordPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ultimine_rewind", (String)"sync_record"));
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<Holder<Item>, Integer>> HOLDER_MAP_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), (StreamCodec)ByteBufCodecs.INT, (int)8192);
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<Item, Integer>> ITEM_MAP_CODEC = HOLDER_MAP_CODEC.map(holderMap -> holderMap.entrySet().stream().collect(Collectors.toMap(entry -> (Item)((Holder)entry.getKey()).value(), Map.Entry::getValue)), itemMap -> {
        HashMap holderMap = new HashMap();
        itemMap.forEach((item, count) -> holderMap.put(Holder.direct((Object)item), count));
        return holderMap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRecordPacket> STREAM_CODEC = StreamCodec.composite(ITEM_MAP_CODEC, SyncRecordPacket::requiredItems, (StreamCodec)ByteBufCodecs.INT, SyncRecordPacket::blockCount, SyncRecordPacket::new);

    public static SyncRecordPacket from(UltimineRecord record) {
        if (record == null) {
            return new SyncRecordPacket(Map.of(), 0);
        }
        return new SyncRecordPacket(record.getRequiredItems(), record.getBlockCount());
    }

    public static void handle(SyncRecordPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (patt0$temp = player.containerMenu) instanceof RewindMenu) {
                RewindMenu menu = (RewindMenu)patt0$temp;
                menu.setClientRecordData(msg.requiredItems(), msg.blockCount());
            }
        });
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

