/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client.deletion;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.api.ItemTrashedEvent;
import net.blay09.mods.trashslot.api.ItemUntrashedEvent;
import net.blay09.mods.trashslot.api.TrashSlotEmptiedEvent;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.network.MessageDeleteFromSlot;
import net.blay09.mods.trashslot.network.MessageTrashSlotClick;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class DefaultDeletionProvider
implements DeletionProvider {
    @Override
    public void undeleteLast(Player player, TrashSlotSlot trashSlot, boolean isRightClick) {
        ItemStack trashStack = trashSlot.getItem();
        ItemStack mouseStack = isRightClick ? trashStack.split(1) : trashStack;
        player.containerMenu.setCarried(mouseStack);
        trashSlot.set(isRightClick ? trashStack : ItemStack.EMPTY);
        Balm.getNetworking().sendToServer((CustomPacketPayload)new MessageTrashSlotClick(ItemStack.EMPTY, isRightClick));
        Balm.getEvents().fireEvent((Object)new ItemUntrashedEvent(player, mouseStack));
    }

    @Override
    public boolean canUndeleteLast() {
        return true;
    }

    @Override
    public void deleteMouseItem(Player player, ItemStack mouseItem, TrashSlotSlot trashSlot, boolean isRightClick) {
        ItemStack mouseStack = mouseItem.copy();
        ItemStack trashStack = isRightClick ? mouseStack.split(1) : mouseStack;
        ItemTrashedEvent.Pre preEvent = new ItemTrashedEvent.Pre(player, trashStack);
        Balm.getEvents().fireEvent((Object)preEvent);
        if (preEvent.isCanceled()) {
            return;
        }
        player.containerMenu.setCarried(isRightClick ? mouseStack : ItemStack.EMPTY);
        trashSlot.set(trashStack);
        Balm.getNetworking().sendToServer((CustomPacketPayload)new MessageTrashSlotClick(mouseItem, isRightClick));
        Balm.getEvents().fireEvent((Object)new ItemTrashedEvent.Post(player, trashStack));
    }

    @Override
    public void deleteContainerItem(Player player, AbstractContainerMenu container, int slotNumber, boolean isDeleteAll, TrashSlotSlot slotTrash) {
        ItemStack itemStack = container.getSlot(slotNumber).getItem();
        ItemTrashedEvent.Pre preEvent = new ItemTrashedEvent.Pre(player, itemStack);
        Balm.getEvents().fireEvent((Object)preEvent);
        if (preEvent.isCanceled()) {
            return;
        }
        Balm.getNetworking().sendToServer((CustomPacketPayload)new MessageDeleteFromSlot(slotNumber, isDeleteAll));
        Balm.getEvents().fireEvent((Object)new ItemTrashedEvent.Post(player, itemStack));
    }

    @Override
    public void emptyTrashSlot(Player player, TrashSlotSlot trashSlot) {
        ItemStack itemStack = trashSlot.getItem();
        trashSlot.set(ItemStack.EMPTY);
        Balm.getNetworking().sendToServer((CustomPacketPayload)new MessageDeleteFromSlot(-1, false));
        Balm.getEvents().fireEvent((Object)new TrashSlotEmptiedEvent(player, itemStack));
    }
}

