/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.BagusLib;
import baguchi.bagus_lib.api.IBaguAnimate;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import baguchi.bagus_lib.client.game.WaterMelonScreen;
import baguchi.bagus_lib.client.render.book.Book;
import baguchi.bagus_lib.client.render.book.component.BookComponentDefinition;
import baguchi.bagus_lib.client.render.book.component.DialogBookComponent;
import baguchi.bagus_lib.client.render.book.component.DisplayBookComponent;
import baguchi.bagus_lib.client.render.screen.BookScreen;
import baguchi.bagus_lib.util.DialogHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.joml.Quaternionfc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="bagus_lib")
public class ClientEventHandler {
    private static boolean initDate = false;
    private static boolean aprilFools = false;

    @SubscribeEvent
    public static void screenRender(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (ClientEventHandler.isAprilFools()) {
                int l = titleScreen.height / 4 + 28;
                event.addListener((GuiEventListener)Button.builder((Component)Component.translatable((String)"bagus_lib.watermelon"), p_280785_ -> Minecraft.getInstance().setScreen((Screen)new WaterMelonScreen((Component)Component.empty()))).bounds(titleScreen.width / 2 + 100, l + 4, 100, 20).build());
            }
        }
    }

    public static void handleOpenPageTest(Player player) {
        if (player.level().isClientSide() && player == Minecraft.getInstance().player) {
            DisplayBookComponent title = new DisplayBookComponent(121, 158).imageDisplay(BagusLib.prefix("textures/gui/sprites/test.png"), 4, 10, 100, 100).textDisplay((Component)Component.literal((String)"test"), 52, 115, 1.2f);
            DialogBookComponent test2 = new DialogBookComponent((Component)Component.literal((String)"test2. testetteafrafdadadsadadasad"), false, 100, 158);
            Book book = new Book(Lists.newArrayList((Object[])new BookComponentDefinition[]{new BookComponentDefinition(title, BagusLib.prefix("title"), 10, 10, 10, 10), new BookComponentDefinition(test2, BagusLib.prefix("test2"), 10, 10, 10, 10)}), 256, 182, 23, 13, 12, 27, BagusLib.prefix("textures/gui/screen/book/book.png"), BagusLib.prefix("textures/gui/screen/book/book_back.png"), BagusLib.prefix("textures/gui/screen/book/book_back.png"), ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/page_backward.png"), ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/page_forward.png"));
            Minecraft.getInstance().setScreen((Screen)new BookScreen(book));
        }
    }

    public static boolean isAprilFools() {
        if (!initDate) {
            initDate = true;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            aprilFools = calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
        }
        return aprilFools && (Boolean)BagusConfigs.COMMON.aprilFool.get() != false || (Boolean)BagusConfigs.COMMON.alwayAplilFool.get() != false;
    }

    @SubscribeEvent
    public static void clientLoggOut(PlayerEvent.PlayerLoggedOutEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void clientRespawn(PlayerEvent.PlayerRespawnEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void animationArmEvent(RenderHandEvent event) {
        IBaguAnimate baguAnimate;
        boolean playFlag;
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)abstractClientPlayer);
        EntityModel entityModel = playerrenderer.getModel();
        if (abstractClientPlayer instanceof IBaguAnimate && (playFlag = (baguAnimate = (IBaguAnimate)abstractClientPlayer).getBaguController().hasPlayingAnimation())) {
            ClientEventHandler.renderArmWithItem((AbstractClientPlayer)abstractClientPlayer, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), entityModel);
            event.setCanceled(true);
        }
    }

    private static void renderArmWithItem(AbstractClientPlayer p_109372_, InteractionHand p_109375_, float p_109376_, ItemStack p_109377_, float p_109378_, PoseStack p_109379_, MultiBufferSource p_109380_, int p_109381_, EntityModel entityModel) {
        if (!p_109372_.isScoping()) {
            boolean flag = p_109375_ == InteractionHand.MAIN_HAND;
            HumanoidArm humanoidarm = flag ? p_109372_.getMainArm() : p_109372_.getMainArm().getOpposite();
            boolean flag2 = humanoidarm == HumanoidArm.RIGHT;
            p_109379_.pushPose();
            if (!p_109372_.isInvisible()) {
                boolean flag3;
                p_109379_.pushPose();
                ClientEventHandler.renderPlayerArm(p_109379_, p_109380_, p_109381_, p_109378_, p_109376_, humanoidarm, entityModel);
                boolean bl = flag3 = humanoidarm == HumanoidArm.LEFT;
                if (entityModel instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.translateToHand(humanoidarm, p_109379_);
                    p_109379_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    p_109379_.translate((float)(flag3 ? -1 : 1) / 16.0f, 0.125f, -0.625f);
                }
                ClientEventHandler.renderItem((LivingEntity)p_109372_, p_109377_, flag3 ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, p_109379_, p_109380_, p_109381_);
                p_109379_.popPose();
            }
            p_109379_.popPose();
        }
    }

    private static void renderItem(LivingEntity p_270072_, ItemStack p_270793_, ItemDisplayContext p_270837_, PoseStack p_270974_, MultiBufferSource p_270686_, int p_270103_) {
        if (!p_270793_.isEmpty()) {
            Minecraft.getInstance().getItemRenderer().renderStatic(p_270072_, p_270793_, p_270837_, p_270974_, p_270686_, p_270072_.level(), p_270103_, OverlayTexture.NO_OVERLAY, p_270072_.getId() + p_270837_.ordinal());
        }
    }

    private static void renderPlayerArm(PoseStack p_109347_, MultiBufferSource p_109348_, int p_109349_, float p_109350_, float p_109351_, HumanoidArm p_109352_, EntityModel entityModel) {
        boolean flag = p_109352_ != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.sqrt((float)p_109351_);
        float f2 = -0.3f * Mth.sin((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.sin((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.sin((float)(p_109351_ * (float)Math.PI));
        p_109347_.translate(f * (f2 + 0.64000005f), f3 + -0.6f + p_109350_ * -0.6f, f4 + -0.71999997f);
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * 45.0f));
        float f5 = Mth.sin((float)(p_109351_ * p_109351_ * (float)Math.PI));
        float f6 = Mth.sin((float)(f1 * (float)Math.PI));
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * f6 * 70.0f));
        p_109347_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = Minecraft.getInstance().player;
        p_109347_.translate(f * -1.0f, 3.6f, 3.5f);
        p_109347_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * 120.0f));
        p_109347_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(200.0f));
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * -135.0f));
        p_109347_.translate(f * 5.6f, 0.0f, 0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)abstractclientplayer);
        ResourceLocation resourcelocation = abstractclientplayer.getSkin().texture();
        if (flag) {
            ClientEventHandler.renderRightHand(p_109347_, p_109348_, p_109349_, resourcelocation, abstractclientplayer.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, entityModel);
        } else {
            ClientEventHandler.renderLeftHand(p_109347_, p_109348_, p_109349_, resourcelocation, abstractclientplayer.isModelPartShown(PlayerModelPart.LEFT_SLEEVE), (AbstractClientPlayer)abstractclientplayer, entityModel);
        }
    }

    public static void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, ResourceLocation p_363694_, boolean p_366898_, AbstractClientPlayer player, EntityModel entityModel) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)p_117771_, (MultiBufferSource)p_117772_, (int)p_117773_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.RIGHT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(p_117771_, p_117772_, p_117773_, p_363694_, playerModel.rightArm, p_366898_, playerModel);
        }
    }

    public static void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, ResourceLocation p_361745_, boolean p_366730_, AbstractClientPlayer player, EntityModel entityModel) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)p_117814_, (MultiBufferSource)p_117815_, (int)p_117816_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.LEFT) && entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ClientEventHandler.renderHand(p_117814_, p_117815_, p_117816_, p_361745_, playerModel.leftArm, p_366730_, playerModel);
        }
    }

    private static void renderHand(PoseStack p_117776_, MultiBufferSource p_117777_, int p_117778_, ResourceLocation p_360319_, ModelPart p_117780_, boolean p_366655_, PlayerModel playermodel) {
        p_117780_.resetPose();
        p_117780_.visible = true;
        playermodel.leftSleeve.visible = p_366655_;
        playermodel.rightSleeve.visible = p_366655_;
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        if (abstractClientPlayer != null) {
            PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)abstractClientPlayer);
            EntityModel entityModel = playerrenderer.getModel();
            if (abstractClientPlayer instanceof IBaguAnimate) {
                IBaguAnimate baguAnimate = (IBaguAnimate)abstractClientPlayer;
                TickRateManager tickratemanager = Minecraft.getInstance().level.tickRateManager();
                PlayerRenderState playerRenderState = (PlayerRenderState)playerrenderer.createRenderState((Entity)abstractClientPlayer, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!tickratemanager.isEntityFrozen((Entity)abstractClientPlayer)));
                playerrenderer.extractRenderState((AbstractClientPlayer)abstractClientPlayer, playerRenderState, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(!tickratemanager.isEntityFrozen((Entity)abstractClientPlayer)));
                BagusModelEvent.PostAnimate event2 = new BagusModelEvent.PostAnimate((LivingEntityRenderState)playerRenderState, entityModel);
                NeoForge.EVENT_BUS.post((Event)event2);
            }
        }
        p_117780_.render(p_117776_, p_117777_.getBuffer(RenderType.entityTranslucent((ResourceLocation)p_360319_)), p_117778_, OverlayTexture.NO_OVERLAY);
    }
}

