/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.layer;

import baguchi.bagus_lib.api.IBagusExtraRenderState;
import baguchi.bagus_lib.client.layer.IArmor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CustomArmorLayer<S extends LivingEntityRenderState, M extends EntityModel<S>, A extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final HumanoidModel defaultBipedModel;
    private final HumanoidModel innerModel;
    private final RenderLayerParent<S, M> renderer;
    private final TextureAtlas armorTrimAtlas;
    private final EquipmentAssetManager equipmentModelSet;
    private final Function<TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    public CustomArmorLayer(RenderLayerParent<S, M> render, EntityRendererProvider.Context context) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.innerModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.renderer = render;
        this.armorTrimAtlas = context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        this.equipmentModelSet = context.getEquipmentAssets();
        this.trimSpriteLookup = Util.memoize(p_386234_ -> context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET).getSprite(p_386234_.spriteId()));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int light, S entity, float p_117353_, float p_117354_) {
        if (entity instanceof IBagusExtraRenderState) {
            IBagusExtraRenderState bagusExtraRenderState = (IBagusExtraRenderState)entity;
            poseStack.pushPose();
            ItemStack headItem = bagusExtraRenderState.getBagusLib$headItem();
            EquipmentClientInfo.LayerType equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.HEAD) ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            Model a = this.getArmorModelHook(headItem, equipmentmodel$layerType, (Model)this.defaultBipedModel);
            boolean flag1 = headItem.hasFoil();
            int clampedLight = light;
            if (headItem.is(ItemTags.DYEABLE)) {
                extensions = IClientItemExtensions.of((ItemStack)headItem);
                i = extensions.getDefaultDyeColor(headItem);
                this.renderHelmet(headItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            } else {
                extensions = IClientItemExtensions.of((ItemStack)headItem);
                i = extensions.getDefaultDyeColor(headItem);
                this.renderHelmet(headItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack chestItem = bagusExtraRenderState.getBagusLib$chestItem();
            equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.CHEST) ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            a = this.getArmorModelHook(chestItem, equipmentmodel$layerType, (Model)this.defaultBipedModel);
            flag1 = chestItem.hasFoil();
            clampedLight = light;
            if (chestItem.is(ItemTags.DYEABLE)) {
                extensions = IClientItemExtensions.of((ItemStack)chestItem);
                i = extensions.getDefaultDyeColor(chestItem);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderChestplate(chestItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            } else {
                extensions = IClientItemExtensions.of((ItemStack)chestItem);
                i = extensions.getDefaultDyeColor(chestItem);
                this.renderChestplate(chestItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack legItem = bagusExtraRenderState.getBagusLib$legItem();
            equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.LEGS) ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            a = this.getArmorModelHook(legItem, equipmentmodel$layerType, (Model)this.innerModel);
            flag1 = legItem.hasFoil();
            clampedLight = light;
            if (legItem.is(ItemTags.DYEABLE)) {
                extensions = IClientItemExtensions.of((ItemStack)legItem);
                i = extensions.getDefaultDyeColor(legItem);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderLeg(legItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            } else {
                extensions = IClientItemExtensions.of((ItemStack)legItem);
                i = extensions.getDefaultDyeColor(legItem);
                this.renderLeg(legItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack feetItem = bagusExtraRenderState.getBagusLib$feetItem();
            equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.FEET) ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            a = this.getArmorModelHook(feetItem, equipmentmodel$layerType, (Model)this.defaultBipedModel);
            boolean notAVanillaModel = a != this.defaultBipedModel;
            flag1 = feetItem.hasFoil();
            clampedLight = light;
            if (feetItem.is(ItemTags.DYEABLE)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                int i = extensions.getDefaultDyeColor(feetItem);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderBoot(feetItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            } else {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                int i = extensions.getDefaultDyeColor(feetItem);
                this.renderBoot(feetItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
            }
            poseStack.popPose();
        }
    }

    private void renderTrim(ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferIn, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> resourceLocation, ModelPart a, int i) {
        ArmorTrim armortrim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        if (armortrim != null) {
            TextureAtlasSprite textureatlassprite = this.trimSpriteLookup.apply(new TrimSpriteKey(armortrim, layerType, resourceLocation));
            VertexConsumer vertexconsumer1 = textureatlassprite.wrap(bufferIn.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)armortrim.pattern().value()).decal())));
            a.render(poseStack, vertexconsumer1, i, OverlayTexture.NO_OVERLAY);
        }
    }

    private static boolean usesInnerModel(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    private void renderLeg(ItemStack legItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, Model modelIn, int color) {
        Equippable equippable = (Equippable)legItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            Function function = modelIn.root().createPartLookup();
            int idx = 0;
            for (EquipmentClientInfo.Layer layer : this.equipmentModelSet.get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)legItem);
                int j = extensions.getArmorLayerTintColor(legItem, layer, idx, color);
                if (j != 0) {
                    ResourceLocation resourcelocation = ClientHooks.getArmorTexture((ItemStack)legItem, (EquipmentClientInfo.LayerType)EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, (EquipmentClientInfo.Layer)layer, (ResourceLocation)layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS));
                    ((IArmor)this.getParentModel()).rightLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("right_leg");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(legItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("left_leg");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(legItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).bodyPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToChest((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("body");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(legItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void renderBoot(ItemStack feetItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, Model modelIn, int color) {
        Equippable equippable = (Equippable)feetItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            Function function = modelIn.root().createPartLookup();
            int idx = 0;
            for (EquipmentClientInfo.Layer layer : this.equipmentModelSet.get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                int j = extensions.getArmorLayerTintColor(feetItem, layer, idx, color);
                if (j != 0) {
                    ResourceLocation resourcelocation = ClientHooks.getArmorTexture((ItemStack)feetItem, (EquipmentClientInfo.LayerType)EquipmentClientInfo.LayerType.HUMANOID, (EquipmentClientInfo.Layer)layer, (ResourceLocation)layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID));
                    ((IArmor)this.getParentModel()).rightLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("right_leg");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(feetItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("left_leg");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(feetItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void resetModelPart(ModelPart part) {
        ModelPart modelPart = part;
        modelPart.x = 0.0f;
        modelPart.y = 0.0f;
        modelPart.z = 0.0f;
        modelPart.xRot = 0.0f;
        modelPart.yRot = 0.0f;
        modelPart.zRot = 0.0f;
    }

    private void renderChestplate(ItemStack chestItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, Model modelIn, int color) {
        Equippable equippable = (Equippable)chestItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            Function function = modelIn.root().createPartLookup();
            int idx = 0;
            for (EquipmentClientInfo.Layer layer : this.equipmentModelSet.get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)chestItem);
                int j = extensions.getArmorLayerTintColor(chestItem, layer, idx, color);
                if (j != 0) {
                    ResourceLocation resourcelocation = ClientHooks.getArmorTexture((ItemStack)chestItem, (EquipmentClientInfo.LayerType)EquipmentClientInfo.LayerType.HUMANOID, (EquipmentClientInfo.Layer)layer, (ResourceLocation)layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID));
                    ((IArmor)this.getParentModel()).rightHandArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToChestPat((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("right_arm");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(chestItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftHandArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToChestPat((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("left_arm");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(chestItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).bodyPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToChest((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("body");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(chestItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void renderHelmet(ItemStack headItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, Model modelIn, int color) {
        Equippable equippable = (Equippable)headItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            Function function = modelIn.root().createPartLookup();
            int idx = 0;
            for (EquipmentClientInfo.Layer layer : this.equipmentModelSet.get((ResourceKey)equippable.assetId().get()).getLayers(EquipmentClientInfo.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)headItem);
                int j = extensions.getArmorLayerTintColor(headItem, layer, idx, color);
                if (j != 0) {
                    ResourceLocation resourcelocation = ClientHooks.getArmorTexture((ItemStack)headItem, (EquipmentClientInfo.LayerType)EquipmentClientInfo.LayerType.HUMANOID, (EquipmentClientInfo.Layer)layer, (ResourceLocation)layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID));
                    ((IArmor)this.getParentModel()).headPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)glintIn);
                        ((IArmor)this.getParentModel()).translateToHead((ModelPart)part, poseStack);
                        ModelPart optional = (ModelPart)function.apply("head");
                        optional.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        this.renderTrim(headItem, poseStack, bufferIn, EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().orElseThrow()), optional, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    protected Model getArmorModelHook(ItemStack itemStack, EquipmentClientInfo.LayerType slot, Model model) {
        Model model2 = IClientItemExtensions.of((Item)itemStack.getItem()).getGenericArmorModel(itemStack, slot, model);
        Function function = model2.root().createPartLookup();
        this.resetModelPart((ModelPart)function.apply("right_leg"));
        this.resetModelPart((ModelPart)function.apply("left_leg"));
        this.resetModelPart((ModelPart)function.apply("right_arm"));
        this.resetModelPart((ModelPart)function.apply("left_arm"));
        this.resetModelPart((ModelPart)function.apply("head"));
        this.resetModelPart((ModelPart)function.apply("body"));
        return model2;
    }

    record TrimSpriteKey(ArmorTrim trim, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAssetId) {
        public ResourceLocation spriteId() {
            return this.trim.layerAssetId(this.layerType.trimAssetPrefix(), this.equipmentAssetId);
        }
    }
}

