/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.entity;

import baguchi.bagus_lib.entity.ISmartJump;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MiniBagu
extends PathfinderMob
implements ISmartJump {
    public MiniBagu(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static AttributeSupplier.Builder createAttributeMap() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean doHurtTarget(ServerLevel p_376642_, Entity p_21372_) {
        return super.doHurtTarget(p_376642_, p_21372_);
    }

    public void aiStep() {
        super.aiStep();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_363352_, @Nullable SpawnGroupData p_21437_) {
        Registry registrylookup1 = this.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
        Registry registrylookup2 = this.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
        ItemStack stack = new ItemStack((ItemLike)Items.LEATHER_HELMET);
        stack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)registrylookup1.getOrThrow(TrimMaterials.EMERALD), (Holder)registrylookup2.getOrThrow(TrimPatterns.SENTRY)));
        this.setItemSlot(EquipmentSlot.HEAD, stack);
        this.setDropChance(EquipmentSlot.HEAD, 0.0f);
        return super.finalizeSpawn(p_21434_, p_21435_, p_363352_, p_21437_);
    }

    protected float getJumpPower() {
        float f = 0.42f;
        Path path = this.navigation.getPath();
        if (path != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
            if (vec3.y > this.getY() + 1.5) {
                f = 0.65f;
            }
        }
        return super.getJumpPower((float)((double)f / this.getAttributeValue(Attributes.JUMP_STRENGTH)));
    }

    @Override
    public float getSuppportJump() {
        return 2.125f;
    }
}

