/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.util.client;

import baguchi.bagus_lib.animation.BaguAnimationController;
import baguchi.bagus_lib.api.IBaguAnimate;
import baguchi.bagus_lib.message.SyncBagusAnimationsMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopAllMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BagusAnimationUtil {
    public static void handleAnimationPacket(Entity entity, ResourceLocation resourceLocation) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().startAnimation(resourceLocation);
            }
        }
    }

    public static void handleStopAnimationPacket(Entity entity, ResourceLocation resourceLocation) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().stopAnimation(resourceLocation);
            }
        }
    }

    public static void handleStopAllAnimationPacket(Entity entity) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            if (entity != null) {
                baguAnimate.getBaguController().stopAllAnimation();
            }
        }
    }

    @Nullable
    public static BaguAnimationController getAnimationController(Entity entity) {
        if (entity instanceof IBaguAnimate) {
            IBaguAnimate baguAnimate = (IBaguAnimate)entity;
            return baguAnimate.getBaguController();
        }
        return null;
    }

    public static void sendAnimation(Entity entity, ResourceLocation resourceLocation) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsMessage(entity.getId(), resourceLocation), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendStopAnimation(Entity entity, ResourceLocation resourceLocation) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsStopMessage(entity.getId(), resourceLocation), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendStopAllAnimation(Entity entity) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncBagusAnimationsStopAllMessage(entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

