/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.data;

import fuzs.easyshulkerboxes.world.item.container.MapProvider;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.data.AbstractItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.ItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.impl.BundleProvider;
import fuzs.iteminteractions.api.v1.provider.impl.ContainerProvider;
import fuzs.iteminteractions.api.v1.provider.impl.EnderChestProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class ModItemContentsProvider
extends AbstractItemContentsProvider {
    public ModItemContentsProvider(DataProviderContext context) {
        super(context);
    }

    public void addItemProviders(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup items = registries.lookupOrThrow(Registries.ITEM);
        this.registerShulkerBoxProviders((HolderLookup.RegistryLookup<Item>)items);
        this.registerBundleProviders((HolderLookup.RegistryLookup<Item>)items);
        this.registerVanillaProviders((HolderLookup.RegistryLookup<Item>)items);
    }

    private void registerVanillaProviders(HolderLookup.RegistryLookup<Item> items) {
        this.add(items, (ItemContentsProvider)new EnderChestProvider(), Items.ENDER_CHEST);
        this.add(items, (ItemContentsProvider)new MapProvider(), Items.FILLED_MAP);
        this.add(items, "dispenser", (ItemContentsProvider)new ContainerProvider(3, 3).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.DISPENSER, Items.DROPPER});
        this.add(items, "chest", (ItemContentsProvider)new ContainerProvider(9, 3).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.CHEST, Items.TRAPPED_CHEST, Items.BARREL});
        this.add(items, (ItemContentsProvider)new ContainerProvider(5, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), Items.HOPPER);
        this.add(items, "furnace", (ItemContentsProvider)new ContainerProvider(3, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.FURNACE, Items.BLAST_FURNACE, Items.SMOKER});
        this.add(items, (ItemContentsProvider)new ContainerProvider(5, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), Items.BREWING_STAND);
        this.add(items, "campfire", (ItemContentsProvider)new ContainerProvider(4, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.CAMPFIRE, Items.SOUL_CAMPFIRE});
    }

    private void registerShulkerBoxProviders(HolderLookup.RegistryLookup<Item> items) {
        this.add(items, (ItemContentsProvider)new ContainerProvider(9, 3).filterContainerItems(true), Items.SHULKER_BOX);
        for (DyeColor dyeColor : DyeColor.values()) {
            ContainerProvider provider = new ContainerProvider(9, 3, DyeBackedColor.fromDyeColor((DyeColor)dyeColor)).filterContainerItems(true);
            this.add(items, (ItemContentsProvider)provider, ShulkerBoxBlock.getBlockByColor((DyeColor)dyeColor).asItem());
        }
    }

    private void registerBundleProviders(HolderLookup.RegistryLookup<Item> items) {
        this.add(items, (ItemContentsProvider)new BundleProvider(DyeBackedColor.fromDyeColor((DyeColor)DyeColor.BROWN)).filterContainerItems(true), Items.BUNDLE);
        for (DyeColor dyeColor : DyeColor.values()) {
            BundleProvider provider = new BundleProvider(DyeBackedColor.fromDyeColor((DyeColor)dyeColor)).filterContainerItems(true);
            this.add(items, (ItemContentsProvider)provider, BundleItem.getByColor((DyeColor)dyeColor));
        }
    }
}

