/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.matyrobbrt.registrationutils;

import com.cursee.matyrobbrt.registrationutils.RegistryObject;
import com.cursee.matyrobbrt.registrationutils.registries.RegistryBuilder;
import com.cursee.matyrobbrt.registrationutils.specialised.SpecialisedRegistrationFactory;
import com.cursee.matyrobbrt.registrationutils.util.$InternalRegUtils;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface RegistrationProvider<T> {
    public static <T> RegistrationProvider<T> get(ResourceKey<? extends Registry<T>> registryKey, String modId) {
        return Factory.INSTANCE.create(registryKey, modId);
    }

    public static <T> RegistrationProvider<T> get(ResourceLocation registryId, String modId) {
        return Factory.INSTANCE.create(ResourceKey.createRegistryKey((ResourceLocation)registryId), modId);
    }

    public static <T> RegistrationProvider<T> get(Registry<T> registry, String modId) {
        return Factory.INSTANCE.create(registry, modId);
    }

    public <I extends T> RegistryObject<T, I> register(String var1, Supplier<? extends I> var2);

    public Collection<RegistryObject<T, ? extends T>> getEntries();

    public ResourceKey<? extends Registry<T>> getRegistryKey();

    public Registry<T> getRegistry();

    public String getModId();

    public RegistryBuilder<T> registryBuilder();

    public static interface Factory
    extends SpecialisedRegistrationFactory {
        public static final Factory INSTANCE = $InternalRegUtils.getOneAndOnlyService(Factory.class);

        public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> var1, String var2);

        default public <T> RegistrationProvider<T> create(Registry<T> registry, String modId) {
            return this.create(registry.key(), modId);
        }
    }
}

