/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.matyrobbrt.registrationutils.neoforge;

import com.cursee.matyrobbrt.registrationutils.RegistrationProvider;
import com.cursee.matyrobbrt.registrationutils.RegistryObject;
import com.cursee.matyrobbrt.registrationutils.neoforge.NeoForgeBusGetter;
import com.cursee.matyrobbrt.registrationutils.registries.RegistryBuilder;
import com.cursee.matyrobbrt.registrationutils.registries.RegistryFeatureType;
import com.cursee.matyrobbrt.registrationutils.specialised.BlockRegistrationProvider;
import com.cursee.matyrobbrt.registrationutils.specialised.BlockRegistryObject;
import com.cursee.matyrobbrt.registrationutils.specialised.ItemRegistrationProvider;
import com.cursee.matyrobbrt.registrationutils.specialised.ItemRegistryObject;
import com.google.auto.service.AutoService;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.jetbrains.annotations.ApiStatus;

@AutoService(value={RegistrationProvider.Factory.class})
public class NeoForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
        Provider provider = new Provider(modId, register);
        IEventBus bus = NeoForgeRegistrationFactory.getBus(modId);
        register.register(bus);
        bus.addListener(provider::onNewRegistry);
        return provider;
    }

    @Nonnull
    @ApiStatus.Internal
    static IEventBus getBus(String modId) {
        Optional containerOpt;
        if (modId.equals("minecraft")) {
            modId = "forge";
        }
        if ((containerOpt = ModList.get().getModContainerById(modId)).isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        IEventBus modBus = NeoForgeBusGetter.getBus((ModContainer)containerOpt.get());
        if (modBus == null) {
            throw new NullPointerException("Cannot get the mod event bus for the mod container with the mod id of " + modId);
        }
        return modBus;
    }

    @Override
    public ItemRegistrationProvider item(String modId) {
        return new ItemProvider(modId);
    }

    @Override
    public BlockRegistrationProvider block(String modId) {
        return new BlockProvider(modId);
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        protected final String modId;
        protected final DeferredRegister<T> registry;
        private Registry<T> customRegistry;
        protected final Set<RegistryObject<T, ? extends T>> entries = new HashSet<RegistryObject<T, ? extends T>>();
        private final Set<RegistryObject<T, ? extends T>> entriesView = Collections.unmodifiableSet(this.entries);
        private final Supplier<Registry<T>> registryInstance = Suppliers.memoize(() -> (Registry)Provider.get(BuiltInRegistries.REGISTRY, this.getRegistryKey()));

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        private void onNewRegistry(NewRegistryEvent event) {
            if (this.customRegistry != null) {
                event.register(this.customRegistry);
            }
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public ResourceKey<? extends Registry<T>> getRegistryKey() {
            return this.registry.getRegistryKey();
        }

        @Override
        public Registry<T> getRegistry() {
            return this.registryInstance.get();
        }

        private static <T> T get(Registry<T> registry, ResourceKey<?> key) {
            return (T)registry.getValueOrThrow(key);
        }

        @Override
        public <I extends T> RegistryObject<T, I> register(String name, Supplier<? extends I> supplier) {
            DeferredHolder obj = this.registry.register(name, supplier);
            RO ro = new RO(this, obj);
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T, ? extends T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public RegistryBuilder<T> registryBuilder() {
            return new Builder();
        }

        protected class RO<I extends T>
        implements RegistryObject<T, I> {
            private final DeferredHolder<T, I> holder;

            protected RO(Provider this$0, DeferredHolder<T, I> holder) {
                this.holder = holder;
            }

            @Override
            public ResourceKey<T> getResourceKey() {
                return this.holder.getKey();
            }

            @Override
            public ResourceLocation getId() {
                return this.holder.getId();
            }

            @Override
            public I get() {
                return (I)this.holder.get();
            }

            @Override
            public Holder<T> asHolder() {
                return this.holder;
            }
        }

        private final class Builder
        implements RegistryBuilder<T> {
            private final net.neoforged.neoforge.registries.RegistryBuilder<T> builder;
            private final Map<RegistryFeatureType<?>, Object> features;

            private Builder() {
                this.builder = new net.neoforged.neoforge.registries.RegistryBuilder(Provider.this.getRegistryKey());
                this.features = new HashMap();
            }

            @Override
            public <X> RegistryBuilder<T> withFeature(RegistryFeatureType<X> type, X value) {
                this.features.put(type, value);
                return this;
            }

            @Override
            public RegistryBuilder<T> withFeature(RegistryFeatureType<Void> type) {
                return this.withFeature(type, null);
            }

            @Override
            public RegistryBuilder<T> withDefaultValue(String id, Supplier<T> defaultValueSupplier) {
                Provider.this.register(id, defaultValueSupplier);
                return this.withFeature(RegistryFeatureType.DEFAULTED, ResourceLocation.fromNamespaceAndPath((String)Provider.this.modId, (String)id));
            }

            @Override
            public Registry<T> build() {
                this.configureBuilder();
                Provider.this.customRegistry = this.builder.create();
                return Provider.this.customRegistry;
            }

            private void configureBuilder() {
                this.builder.sync(this.features.containsKey(RegistryFeatureType.SYNCED));
                if (this.features.containsKey(RegistryFeatureType.DEFAULTED)) {
                    this.builder.defaultKey((ResourceLocation)this.features.get(RegistryFeatureType.DEFAULTED));
                }
            }
        }
    }

    private static class ItemProvider
    extends Provider<Item>
    implements ItemRegistrationProvider {
        private ItemProvider(String modId) {
            super(modId, DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)modId));
        }

        @Override
        public <I extends Item> ItemRegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            ItemRO obj = new ItemRO(this, this.registry.register(name, supplier));
            this.entries.add(obj);
            return obj;
        }

        private class ItemRO<I extends Item>
        extends Provider.RO<I>
        implements ItemRegistryObject<I> {
            protected ItemRO(ItemProvider itemProvider, DeferredHolder<Item, I> holder) {
                super(itemProvider, holder);
            }
        }
    }

    private static class BlockProvider
    extends Provider<Block>
    implements BlockRegistrationProvider {
        private BlockProvider(String modId) {
            super(modId, DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)modId));
        }

        @Override
        public <B extends Block> BlockRegistryObject<B> register(String name, Supplier<? extends B> supplier) {
            BlockRO obj = new BlockRO(this, this.registry.register(name, supplier));
            this.entries.add(obj);
            return obj;
        }

        private class BlockRO<B extends Block>
        extends Provider.RO<B>
        implements BlockRegistryObject<B> {
            protected BlockRO(BlockProvider blockProvider, DeferredHolder<Block, B> holder) {
                super(blockProvider, holder);
            }
        }
    }
}

