/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.matyrobbrt.registrationutils.util;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DatapackRegistryGenerator
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final Predicate<RegistryDataLoader.RegistryData<?>> predicate;

    public DatapackRegistryGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, Predicate<RegistryDataLoader.RegistryData<?>> predicate) {
        this.registries = lookup;
        this.output = output;
        this.predicate = predicate;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(lookup -> {
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup);
            return CompletableFuture.allOf((CompletableFuture[])RegistryDataLoader.WORLDGEN_REGISTRIES.stream().filter(this.predicate).flatMap(arg_0 -> this.lambda$run$0(output, lookup, (DynamicOps)ops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(CachedOutput output, HolderLookup.Provider lookup, DynamicOps<JsonElement> ops, RegistryDataLoader.RegistryData<T> data) {
        ResourceKey registryKey = data.key();
        return lookup.lookup(registryKey).map(registry -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, registryKey.location().getPath());
            return CompletableFuture.allOf((CompletableFuture[])registry.listElements().map(value -> DatapackRegistryGenerator.dumpValue(pathProvider.json(value.key().location()), output, ops, data.elementCodec(), value.value())).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpValue(Path path, CachedOutput output, DynamicOps<JsonElement> ops, Encoder<E> codec, E value) {
        Optional encoded = codec.encodeStart(ops, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        return encoded.isPresent() ? DataProvider.saveStable((CachedOutput)output, (JsonElement)((JsonElement)encoded.get()), (Path)path) : CompletableFuture.completedFuture(null);
    }

    public String getName() {
        return String.valueOf(this.predicate) + " registry";
    }

    private /* synthetic */ Stream lambda$run$0(CachedOutput output, HolderLookup.Provider lookup, DynamicOps ops, RegistryDataLoader.RegistryData data) {
        return this.dumpRegistryCap(output, lookup, (DynamicOps<JsonElement>)ops, data).stream();
    }
}

