/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib;

import com.cursee.moandjiezana.toml.Toml;
import com.cursee.moandjiezana.toml.TomlWriter;
import com.cursee.monolib.Constants;
import com.cursee.monolib.core.sailing.Sailing;
import com.cursee.monolib.core.sailing.warden.SailingWarden;
import com.cursee.monolib.platform.Services;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import net.minecraft.resources.ResourceLocation;

public class MonoLib {
    public static boolean debugging = false;
    public static boolean verifyJarFiles = true;

    public static void init() {
        SailingWarden.process(Services.PLATFORM.getGameDirectory() + File.separator + "mods");
        Sailing.register("monolib", "MonoLib", "3.0.2", "Lupin", "https://www.curseforge.com/minecraft/mc-mods/monolib");
        MonoLib.createOrLoadConfiguration();
    }

    public static ResourceLocation identifier(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"monolib", (String)path);
    }

    private static void createOrLoadConfiguration() {
        File configFile;
        String configDirString = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        String configFileString = configDirString + File.separator + "monolib-common.toml";
        File configDir = new File(configDirString);
        if (!configDir.isDirectory() && !configDir.mkdirs()) {
            Constants.LOG.info("Unable to create {}, config retaining default values.", (Object)configDirString);
        }
        if ((configFile = new File(configFileString)).exists()) {
            Toml toml = new Toml().read(configFile);
            debugging = toml.getBoolean("debugging", debugging);
            verifyJarFiles = toml.getBoolean("verify_jar_files", verifyJarFiles);
        } else {
            TomlWriter writer = new TomlWriter();
            LinkedHashMap<String, Boolean> defaults = new LinkedHashMap<String, Boolean>();
            defaults.put("debugging", debugging);
            defaults.put("verify_jar_files", verifyJarFiles);
            try {
                writer.write(defaults, configFile);
            }
            catch (IOException e) {
                Constants.LOG.info(e.getMessage());
            }
        }
    }
}

