/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleConfig {
    private final Map<String, String> values = new LinkedHashMap<String, String>();

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public boolean contains(String key) {
        return this.values.containsKey(key);
    }

    public void set(String key, Object value) {
        this.values.put(key, String.valueOf(value));
    }

    public void setList(String key, List<?> list) {
        String serialized = "[" + list.stream().map(o -> o instanceof String ? "\"" + String.valueOf(o) + "\"" : o.toString()).collect(Collectors.joining(", ")) + "]";
        this.values.put(key, serialized);
    }

    public String getString(String key, String def) {
        return this.values.get(key) == null ? def : this.values.get(key);
    }

    public int getInt(String key, int def) {
        try {
            return this.values.get(key) == null ? def : Integer.parseInt(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public long getLong(String key, long def) {
        try {
            return this.values.get(key) == null ? def : Long.parseLong(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public double getDouble(String key, double def) {
        try {
            return this.values.get(key) == null ? def : Double.parseDouble(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            return this.values.get(key) == null ? def : Boolean.parseBoolean(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public float getFloat(String key, float def) {
        try {
            return this.values.get(key) == null ? def : Float.parseFloat(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public short getShort(String key, short def) {
        try {
            return this.values.get(key) == null ? def : Short.parseShort(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public byte getByte(String key, byte def) {
        try {
            return this.values.get(key) == null ? def : Byte.parseByte(this.values.get(key));
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static void printFailureToParse(String s, Object o) {
        System.out.println("Failed to parse value for " + s + ", using default " + String.valueOf(o));
    }

    public <T> List<T> getList(String key, List<T> defaults, Class<T> type) {
        try {
            String raw = this.values.get(key);
            if (raw == null) {
                return defaults;
            }
            if ((raw = raw.trim()).startsWith("[") && raw.endsWith("]")) {
                raw = raw.substring(1, raw.length() - 1);
            }
            if (raw.isEmpty()) {
                return Collections.emptyList();
            }
            String[] parts = raw.split(",");
            ArrayList<Object> result = new ArrayList<Object>();
            for (String part : parts) {
                String trimmed = part.trim();
                Object parsed = this.parseValue(trimmed, type);
                if (parsed == null) {
                    SimpleConfig.printFailureToParse(key, defaults);
                    return defaults;
                }
                result.add(parsed);
            }
            return result;
        }
        catch (Exception e) {
            SimpleConfig.printFailureToParse(key, defaults);
            return defaults;
        }
    }

    private Object parseValue(String value, Class<?> type) {
        try {
            if (type == String.class) {
                return value.replaceAll("^\"|\"$", "");
            }
            if (type == Integer.class) {
                return Integer.parseInt(value);
            }
            if (type == Long.class) {
                return Long.parseLong(value);
            }
            if (type == Double.class) {
                return Double.parseDouble(value);
            }
            if (type == Float.class) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (type == Boolean.class) {
                return Boolean.parseBoolean(value);
            }
            if (type == Short.class) {
                return Short.parseShort(value);
            }
            if (type == Byte.class) {
                return Byte.parseByte(value);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    public static SimpleConfig load(Path path) {
        SimpleConfig cfg = new SimpleConfig();
        if (!Files.exists(path, new LinkOption[0])) {
            return cfg;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                int eq;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int hash = line.indexOf(35);
                if (hash >= 0) {
                    line = line.substring(0, hash).trim();
                }
                if ((eq = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                cfg.values.put(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cfg;
    }

    public void save(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry<String, String> e : this.values.entrySet()) {
                writer.write(e.getKey() + "=" + e.getValue());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

