/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.config;

import com.cursee.monolib.config.SimpleConfig;
import com.cursee.monolib.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class SimpleConfigIO {
    public static void createOrLoadConfiguration(Class<?> loadingClass, String filename, Consumer<SimpleConfig> defaultsProvider, Consumer<SimpleConfig> loader) {
        File cfg;
        String cfgDirPath = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File cfgDir = new File(cfgDirPath);
        if (!cfgDir.exists() && !cfgDir.mkdirs()) {
            System.out.println("Insufficient privileges to make new directory: " + cfgDirPath);
            System.out.println("Retaining default values for all configurations.");
        }
        if (!(cfg = new File(cfgDirPath + File.separator + filename)).exists()) {
            InputStream ioStream = loadingClass.getClassLoader().getResourceAsStream("assets/" + filename);
            if (ioStream == null) {
                System.out.println("Could not find default config resource: assets/" + filename);
                System.out.println("Configuration will retain default values.");
                SimpleConfig sCfg = new SimpleConfig();
                defaultsProvider.accept(sCfg);
                sCfg.save(cfg.toPath());
                return;
            }
            try (InputStream inputStream = ioStream;
                 BufferedInputStream bis = new BufferedInputStream(inputStream);
                 BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cfg));){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                System.out.println("Failed to copy default config file, error: " + e.getMessage());
                System.out.println("Configuration will retain default values.");
            }
        } else {
            SimpleConfig sCfg = SimpleConfig.load(cfg.toPath());
            loader.accept(sCfg);
        }
    }
}

