/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command.data;

import com.cursee.monolib.core.command.util.IEnumCommandArg;
import com.cursee.monolib.core.command.util.IItemFormat;
import com.cursee.monolib.core.serialization.codecs.map.MapCodecs;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum FormatArgument implements IEnumCommandArg
{
    ITEM_ID((stack, level) -> {
        String s = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        return Component.literal((String)s).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(s)));
    }),
    AS_STRING((stack, level) -> {
        String s = stack.toString();
        return Component.literal((String)s).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(s)));
    }),
    AS_INGREDIENT(FormatArgument.fromCodec(MapCodecs.INGREDIENT.get(), (stack, level) -> Ingredient.of((ItemLike)stack.getItem()))),
    FULL_JSON(FormatArgument.fromCodec(MapCodecs.ITEM_STACK.get(), (stack, level) -> stack)),
    TAGS((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getTags().forEach(itemTagKey -> joiner.add(itemTagKey.location().toString()));
        return Component.literal((String)joiner.toString()).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(joiner.toString())));
    }),
    DATA_COMPONENTS((stack, level) -> {
        StringJoiner joiner = new StringJoiner("\n");
        stack.getComponents().forEach(typedDataComponent -> joiner.add(typedDataComponent.toString()));
        return Component.literal((String)joiner.toString()).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(joiner.toString())));
    });

    private final IItemFormat format;

    private FormatArgument(IItemFormat format) {
        this.format = format;
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int run(CommandContext<CommandSourceStack> commandContext) {
        return 1;
    }

    public IItemFormat getFormat() {
        return this.format;
    }

    private static <T> IItemFormat fromCodec(Codec<T> codec, BiFunction<ItemStack, ServerLevel, T> mapper) {
        return (stack, level) -> {
            if (stack.isEmpty()) {
                return Component.literal((String)"Item must not be empty or air!").withStyle(ChatFormatting.RED);
            }
            Object value = mapper.apply(stack, level);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), value).getOrThrow();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return Component.literal((String)gson.toJson(json)).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.CopyToClipboard(gson.toJson(json))));
        };
    }
}

