/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.sailing;

import com.cursee.monolib.Constants;
import com.cursee.monolib.MonoLib;
import com.cursee.monolib.core.sailing.Sailing;
import com.cursee.monolib.core.sailing.SailingEntry;
import com.cursee.monolib.core.sailing.SailingMessage;
import com.cursee.monolib.core.sailing.warden.SailingWarden;
import com.cursee.monolib.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.ArrayUtils;

public class SailingUtility {
    public static void onEntityJoinLevel(Entity entity, Level level) {
        boolean ENTITY_IS_PLAYER = entity instanceof Player;
        boolean VERIFY_JAR_CONFIG_VALUE = MonoLib.verifyJarFiles;
        boolean INSTANCE_UNVERIFIED = Sailing.unverified;
        boolean ENTITY_CHECKED = entity.getTags().contains("monolib.sc");
        if (!ENTITY_IS_PLAYER || !VERIFY_JAR_CONFIG_VALUE || !INSTANCE_UNVERIFIED || ENTITY_CHECKED) {
            return;
        }
        Player player = (Player)entity;
        if (!SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.isEmpty()) {
            SailingMessage.sendMessage(player, "Unsafe download(s):", ChatFormatting.WHITE);
            Constants.LOG.info("Unsafe download(s):");
            for (String key : SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.keySet()) {
                SailingMessage.sendMessage(player, "- " + key + " from " + SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.get(key), ChatFormatting.WHITE);
                Constants.LOG.info("- {} from {}", (Object)key, (Object)SailingWarden.UNSAFE_PATH_TO_UNSAFE_HOST_MAP.get(key));
            }
        }
        SailingUtility.verifyJarFiles(player, level);
        entity.addTag("monolib.sc");
    }

    private static void verifyJarFiles(Player player, Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        List<String> MOD_NAMES_MISSING_JAR_FILE = SailingUtility.getModNamesMissingJarFile();
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty() && SailingUtility.preVerificationProcess(level)) {
            SailingMessage.sendMessage(player, "Mod(s) from incorrect sources:", ChatFormatting.RED);
            for (String modName : MOD_NAMES_MISSING_JAR_FILE) {
                SailingEntry entry = Sailing.MOD_NAME_TO_ENTRY.get(modName);
                SailingMessage.sendMessage(player, modName + " by " + entry.modPublisher() + " (Click Here)", ChatFormatting.YELLOW, entry.modURL());
            }
            SailingMessage.sendMessage(player, "You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.", ChatFormatting.RED);
            SailingMessage.sendMessage(player, "Click on the name of the mod above to find it's original posting.", ChatFormatting.DARK_GREEN);
            SailingMessage.sendMessage(player, "You won't see this message again in this instance. Thank you for reading.", ChatFormatting.DARK_GREEN);
            Constants.LOG.info("You a receiving this message because one or more of your mod files has been altered and possibly not downloaded from an original and safe source. Unofficial sources can contain malicious software or host outdated versions of mods, as well as removing ad revenue from mod authors.");
            Constants.LOG.info("Click on the name of the mod above to find it's original posting.");
            Constants.LOG.info("You won't see this message again in this instance. Thank you for reading.");
            SailingUtility.postVerificationProcess(level);
        }
        Sailing.unverified = false;
    }

    private static boolean preVerificationProcess(Level level) {
        Object path = ((ServerLevel)level).getServer().getWorldPath(LevelResource.ROOT).toString();
        path = ((String)path).substring(0, ((String)path).length() - 2) + File.separator + "config" + File.separator + "monolib" + File.separator + "checked.txt";
        File checkFile = new File((String)path);
        String alternativePath = Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + "monolib" + File.separator + "checked.txt";
        File alternativeFile = new File(alternativePath);
        if (checkFile.exists()) {
            Sailing.unverified = false;
        } else if (alternativeFile.exists()) {
            Sailing.unverified = false;
        }
        return Sailing.unverified;
    }

    private static void postVerificationProcess(Level level) {
        Sailing.unverified = false;
        Object path = ((ServerLevel)level).getServer().getWorldPath(LevelResource.ROOT).toString();
        File directory = new File((String)(path = ((String)path).substring(0, ((String)path).length() - 2) + File.separator + "config" + File.separator + "monolib"));
        if (!directory.mkdirs()) {
            return;
        }
        try (PrintWriter writer2 = new PrintWriter((String)path + File.separator + "checked.txt", StandardCharsets.UTF_8);){
            writer2.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer2.println("checked=true");
        }
        catch (Exception writer2) {
            // empty catch block
        }
        Object alternativePath = Services.PLATFORM.getGameDirectory();
        alternativePath = (String)alternativePath + File.separator + "config" + File.separator + "monolib";
        if (new File((String)alternativePath + File.separator + "checked.txt").isFile()) {
            return;
        }
        File alternativeDirectory = new File((String)alternativePath);
        if (!alternativeDirectory.mkdirs()) {
            return;
        }
        try (PrintWriter writer = new PrintWriter((String)alternativePath + File.separator + "checked.txt", StandardCharsets.UTF_8);){
            writer.println("# Please check out https://stopmodreposts.org/ for more information on why this feature exists.");
            writer.println("checked=true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<String> getInstalledModFilenames() {
        ArrayList<String> INSTALLED_MOD_FILENAMES = new ArrayList<String>();
        File MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "mods");
        Object[] DISCOVERED_FILES = MOD_DIRECTORY.listFiles();
        File VERSIONED_MOD_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "mods" + File.separator + "1.21.8");
        Object[] DISCOVERED_VERSIONED_FILES = VERSIONED_MOD_DIRECTORY.listFiles();
        if (DISCOVERED_FILES == null && DISCOVERED_VERSIONED_FILES == null) {
            return new ArrayList<String>();
        }
        for (File file : (File[])ArrayUtils.addAll((Object[])DISCOVERED_FILES, (Object[])DISCOVERED_VERSIONED_FILES)) {
            if (!file.isFile()) continue;
            String filename = file.getName().replaceAll(" +\\([0-9]+\\)", "");
            INSTALLED_MOD_FILENAMES.add(filename);
        }
        return INSTALLED_MOD_FILENAMES;
    }

    private static List<String> getModNamesMissingJarFile() {
        List<String> INSTALLED_MOD_FILENAMES = SailingUtility.getInstalledModFilenames();
        ArrayList<String> MOD_NAMES_MISSING_JAR_FILE = new ArrayList<String>();
        for (String filename : Sailing.FILENAME_TO_MOD_NAME.keySet()) {
            boolean CONTAINS_MERGED = INSTALLED_MOD_FILENAMES.contains(filename);
            boolean CONTAINS_FABRIC = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-fabric-"));
            boolean CONTAINS_FORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-forge-"));
            boolean CONTAINS_NEOFORGE = INSTALLED_MOD_FILENAMES.contains(filename.replace("-merged-", "-neoforge-"));
            if (INSTALLED_MOD_FILENAMES.isEmpty() || CONTAINS_MERGED || CONTAINS_FABRIC || CONTAINS_FORGE || CONTAINS_NEOFORGE || !Sailing.FILENAME_TO_MOD_NAME.containsKey(filename)) continue;
            MOD_NAMES_MISSING_JAR_FILE.add(Sailing.FILENAME_TO_MOD_NAME.get(filename));
        }
        if (!MOD_NAMES_MISSING_JAR_FILE.isEmpty()) {
            Collections.sort(MOD_NAMES_MISSING_JAR_FILE);
        }
        return MOD_NAMES_MISSING_JAR_FILE;
    }
}

