/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.sailing.warden;

import com.cursee.monolib.Constants;
import com.cursee.monolib.MonoLib;
import com.cursee.monolib.core.sailing.warden.DomainRules;
import com.cursee.monolib.core.sailing.warden.ZoneIdentifier;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SailingWarden {
    public static final Map<String, String> UNSAFE_PATH_TO_UNSAFE_HOST_MAP = new HashMap<String, String>();

    public static void process(String modsDirectory) {
        if (!MonoLib.verifyJarFiles) {
            return;
        }
        DomainRules domainRules = DomainRules.builtin();
        try {
            if (!SailingWarden.checkFileOrDirectory(domainRules, Paths.get(modsDirectory, new String[0]).toFile())) {
                Constants.LOG.info("Warden did not detect any unsafe JAR files in {}", (Object)modsDirectory);
                Constants.LOG.info("You can disable this message by setting \"verify_jar_files\" in config/monolib-common.txt to false.");
            }
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException("Invalid path specified. '" + modsDirectory + "'");
        }
        if (UNSAFE_PATH_TO_UNSAFE_HOST_MAP.isEmpty()) {
            return;
        }
        Constants.LOG.info("Unsafe download(s):");
        for (String key : UNSAFE_PATH_TO_UNSAFE_HOST_MAP.keySet()) {
            Constants.LOG.info("- {} from {}", (Object)key, (Object)UNSAFE_PATH_TO_UNSAFE_HOST_MAP.get(key));
        }
    }

    private static boolean checkFileOrDirectory(DomainRules rules, File target) {
        boolean hasMatch = false;
        if (!target.exists()) {
            throw new IllegalArgumentException("The file does not exist! '" + target.getAbsolutePath() + "'");
        }
        if (target.isFile()) {
            ZoneIdentifier zoneId = ZoneIdentifier.of(target);
            if (zoneId != null && rules.test(zoneId)) {
                UNSAFE_PATH_TO_UNSAFE_HOST_MAP.put(target.getName(), zoneId.getHost());
                hasMatch = true;
            }
        } else if (target.isDirectory()) {
            for (File subTarget : Objects.requireNonNull(target.listFiles())) {
                hasMatch = hasMatch || SailingWarden.checkFileOrDirectory(rules, subTarget);
            }
        }
        return hasMatch;
    }
}

