/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.json.JsonElementImpl;

public interface JsonElement {
    public static Result<JsonElement, Problem> parseString(String jsonData, JsonPath jsonPath) {
        return JsonElement.parseReader(new StringReader(jsonData), jsonPath);
    }

    public static Result<JsonElement, Problem> parseReader(Reader reader, JsonPath jsonPath) {
        try {
            return Result.success(new JsonElementImpl(JsonParser.parseReader((Reader)reader), jsonPath));
        }
        catch (Exception e) {
            return Result.failure(jsonPath.createProblem("Could not parse JSON due to malformed syntax"));
        }
    }

    public static Result<JsonElement, Problem> parseFile(Path filePath, JsonPath jsonPath) {
        try {
            String content = Files.readString(filePath);
            if (content.isEmpty()) {
                return Result.failure(jsonPath.createProblem("File is empty"));
            }
            return JsonElement.parseString(content, jsonPath);
        }
        catch (Exception e) {
            return Result.failure(jsonPath.createProblem("Could not read file"));
        }
    }

    public Result<JsonObject, Problem> getAsObject();

    public Result<JsonArray, Problem> getAsArray();

    public Result<String, Problem> getAsString();

    public Result<Float, Problem> getAsFloat();

    public Result<Double, Problem> getAsDouble();

    public Result<Integer, Problem> getAsInt();

    public Result<Boolean, Problem> getAsBoolean();

    public JsonPath getPath();

    public com.google.gson.JsonElement getJson();
}

