/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.colors;

import java.util.ArrayList;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.colors.ColorConfig;
import net.puffish.skillsmod.config.colors.ConnectionsColorsConfig;
import net.puffish.skillsmod.config.colors.FillStrokeColorsConfig;
import net.puffish.skillsmod.util.LegacyUtils;

public record ColorsConfig(ConnectionsColorsConfig connections, FillStrokeColorsConfig points) {
    private static final FillStrokeColorsConfig DEFAULT_POINTS = new FillStrokeColorsConfig(new ColorConfig(-8323296), new ColorConfig(-16777216));

    public static ColorsConfig createDefault() {
        return new ColorsConfig(ConnectionsColorsConfig.createDefault(), DEFAULT_POINTS);
    }

    public static Result<ColorsConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> ColorsConfig.parse(rootObject, context), context));
    }

    private static Result<ColorsConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ConnectionsColorsConfig connections = rootObject.get("connections").getSuccess().flatMap(element -> ConnectionsColorsConfig.parse(element, context).ifFailure(problems::add).getSuccess()).orElseGet(ConnectionsColorsConfig::createDefault);
        FillStrokeColorsConfig points = rootObject.get("points").getSuccess().flatMap(element -> FillStrokeColorsConfig.parse(element, DEFAULT_POINTS, context).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_POINTS);
        if (problems.isEmpty()) {
            return Result.success(new ColorsConfig(connections, points));
        }
        return Result.failure(Problem.combine(problems));
    }
}

